package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeBudgetResponse(budget: scala.Option[Budget] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse = {
    import DescribeBudgetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse.builder().optionallyWith(budget.map(value => value.buildAwsValue()))(_.budget).build()
  }
  def asReadOnly: DescribeBudgetResponse.ReadOnly = DescribeBudgetResponse.wrap(buildAwsValue())
}
object DescribeBudgetResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeBudgetResponse = DescribeBudgetResponse(budgetValue.map(value => value.editable))
    def budgetValue: scala.Option[Budget.ReadOnly]
    def budget: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Budget.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("budget", budgetValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse) extends DescribeBudgetResponse.ReadOnly { override def budgetValue: scala.Option[Budget.ReadOnly] = scala.Option(impl.budget()).map(value => Budget.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse): ReadOnly = new Wrapper(impl)
}