package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeBudgetActionRequest(accountId: primitives.AccountId, budgetName: primitives.BudgetName, actionId: primitives.ActionId) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DescribeBudgetActionRequest = {
    import DescribeBudgetActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionRequest.builder().accountId(accountId: java.lang.String).budgetName(budgetName: java.lang.String).actionId(actionId: java.lang.String).build()
  }
  def asReadOnly: DescribeBudgetActionRequest.ReadOnly = DescribeBudgetActionRequest.wrap(buildAwsValue())
}
object DescribeBudgetActionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DescribeBudgetActionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeBudgetActionRequest = DescribeBudgetActionRequest(accountIdValue, budgetNameValue, actionIdValue)
    def accountIdValue: primitives.AccountId
    def budgetNameValue: primitives.BudgetName
    def actionIdValue: primitives.ActionId
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
    def actionId: ZIO[Any, Nothing, primitives.ActionId] = ZIO.succeed(actionIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionRequest) extends DescribeBudgetActionRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
    override def actionIdValue: primitives.ActionId = impl.actionId(): primitives.ActionId
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionRequest): ReadOnly = new Wrapper(impl)
}