package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteBudgetRequest(accountId: primitives.AccountId, budgetName: primitives.BudgetName) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest = {
    import DeleteBudgetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest.builder().accountId(accountId: java.lang.String).budgetName(budgetName: java.lang.String).build()
  }
  def asReadOnly: DeleteBudgetRequest.ReadOnly = DeleteBudgetRequest.wrap(buildAwsValue())
}
object DeleteBudgetRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteBudgetRequest = DeleteBudgetRequest(accountIdValue, budgetNameValue)
    def accountIdValue: primitives.AccountId
    def budgetNameValue: primitives.BudgetName
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest) extends DeleteBudgetRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest): ReadOnly = new Wrapper(impl)
}