package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Definition(iamActionDefinition: scala.Option[IamActionDefinition] = None, scpActionDefinition: scala.Option[ScpActionDefinition] = None, ssmActionDefinition: scala.Option[SsmActionDefinition] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.Definition = {
    import Definition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.Definition.builder().optionallyWith(iamActionDefinition.map(value => value.buildAwsValue()))(_.iamActionDefinition).optionallyWith(scpActionDefinition.map(value => value.buildAwsValue()))(_.scpActionDefinition).optionallyWith(ssmActionDefinition.map(value => value.buildAwsValue()))(_.ssmActionDefinition).build()
  }
  def asReadOnly: Definition.ReadOnly = Definition.wrap(buildAwsValue())
}
object Definition {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.Definition] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Definition = Definition(iamActionDefinitionValue.map(value => value.editable), scpActionDefinitionValue.map(value => value.editable), ssmActionDefinitionValue.map(value => value.editable))
    def iamActionDefinitionValue: scala.Option[IamActionDefinition.ReadOnly]
    def scpActionDefinitionValue: scala.Option[ScpActionDefinition.ReadOnly]
    def ssmActionDefinitionValue: scala.Option[SsmActionDefinition.ReadOnly]
    def iamActionDefinition: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, IamActionDefinition.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iamActionDefinition", iamActionDefinitionValue)
    def scpActionDefinition: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ScpActionDefinition.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("scpActionDefinition", scpActionDefinitionValue)
    def ssmActionDefinition: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SsmActionDefinition.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ssmActionDefinition", ssmActionDefinitionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.Definition) extends Definition.ReadOnly {
    override def iamActionDefinitionValue: scala.Option[IamActionDefinition.ReadOnly] = scala.Option(impl.iamActionDefinition()).map(value => IamActionDefinition.wrap(value))
    override def scpActionDefinitionValue: scala.Option[ScpActionDefinition.ReadOnly] = scala.Option(impl.scpActionDefinition()).map(value => ScpActionDefinition.wrap(value))
    override def ssmActionDefinitionValue: scala.Option[SsmActionDefinition.ReadOnly] = scala.Option(impl.ssmActionDefinition()).map(value => SsmActionDefinition.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.Definition): ReadOnly = new Wrapper(impl)
}