package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.{BudgetName, AccountId}
import scala.jdk.CollectionConverters.*
final case class UpdateBudgetActionResponse(
    accountId: AccountId,
    budgetName: BudgetName,
    oldAction: io.github.vigoo.zioaws.budgets.model.Action,
    newAction: io.github.vigoo.zioaws.budgets.model.Action
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.UpdateBudgetActionResponse = {
    import UpdateBudgetActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.UpdateBudgetActionResponse
      .builder()
      .accountId(accountId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .oldAction(oldAction.buildAwsValue())
      .newAction(newAction.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionResponse.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionResponse
      .wrap(buildAwsValue())
}
object UpdateBudgetActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.UpdateBudgetActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionResponse =
      io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionResponse(
        accountIdValue,
        budgetNameValue,
        oldActionValue.editable,
        newActionValue.editable
      )
    def accountIdValue: AccountId
    def budgetNameValue: BudgetName
    def oldActionValue: io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
    def newActionValue: io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
    def oldAction: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
    ] = ZIO.succeed(oldActionValue)
    def newAction: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
    ] = ZIO.succeed(newActionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.UpdateBudgetActionResponse
  ) extends io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionResponse.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
    override def oldActionValue
        : io.github.vigoo.zioaws.budgets.model.Action.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Action.wrap(impl.oldAction())
    override def newActionValue
        : io.github.vigoo.zioaws.budgets.model.Action.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Action.wrap(impl.newAction())
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.UpdateBudgetActionResponse
  ): io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionResponse.ReadOnly =
    new Wrapper(impl)
}
