package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
sealed trait TimeUnit {
  def unwrap: software.amazon.awssdk.services.budgets.model.TimeUnit
}
object TimeUnit {
  def wrap(
      value: software.amazon.awssdk.services.budgets.model.TimeUnit
  ): io.github.vigoo.zioaws.budgets.model.TimeUnit = value match {
    case software.amazon.awssdk.services.budgets.model.TimeUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.budgets.model.TimeUnit.DAILY =>
      val r = DAILY
      r
    case software.amazon.awssdk.services.budgets.model.TimeUnit.MONTHLY =>
      val r = MONTHLY
      r
    case software.amazon.awssdk.services.budgets.model.TimeUnit.QUARTERLY =>
      val r = QUARTERLY
      r
    case software.amazon.awssdk.services.budgets.model.TimeUnit.ANNUALLY =>
      val r = ANNUALLY
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.budgets.model.TimeUnit {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.TimeUnit =
      software.amazon.awssdk.services.budgets.model.TimeUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object DAILY extends io.github.vigoo.zioaws.budgets.model.TimeUnit {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.TimeUnit =
      software.amazon.awssdk.services.budgets.model.TimeUnit.DAILY
  }
  case object MONTHLY extends io.github.vigoo.zioaws.budgets.model.TimeUnit {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.TimeUnit =
      software.amazon.awssdk.services.budgets.model.TimeUnit.MONTHLY
  }
  case object QUARTERLY extends io.github.vigoo.zioaws.budgets.model.TimeUnit {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.TimeUnit =
      software.amazon.awssdk.services.budgets.model.TimeUnit.QUARTERLY
  }
  case object ANNUALLY extends io.github.vigoo.zioaws.budgets.model.TimeUnit {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.TimeUnit =
      software.amazon.awssdk.services.budgets.model.TimeUnit.ANNUALLY
  }
}
