package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
sealed trait ThresholdType {
  def unwrap: software.amazon.awssdk.services.budgets.model.ThresholdType
}
object ThresholdType {
  def wrap(
      value: software.amazon.awssdk.services.budgets.model.ThresholdType
  ): io.github.vigoo.zioaws.budgets.model.ThresholdType = value match {
    case software.amazon.awssdk.services.budgets.model.ThresholdType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.budgets.model.ThresholdType.PERCENTAGE =>
      val r = PERCENTAGE
      r
    case software.amazon.awssdk.services.budgets.model.ThresholdType.ABSOLUTE_VALUE =>
      val r = ABSOLUTE_VALUE
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.budgets.model.ThresholdType {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ThresholdType =
      software.amazon.awssdk.services.budgets.model.ThresholdType.UNKNOWN_TO_SDK_VERSION
  }
  case object PERCENTAGE
      extends io.github.vigoo.zioaws.budgets.model.ThresholdType {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ThresholdType =
      software.amazon.awssdk.services.budgets.model.ThresholdType.PERCENTAGE
  }
  case object ABSOLUTE_VALUE
      extends io.github.vigoo.zioaws.budgets.model.ThresholdType {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ThresholdType =
      software.amazon.awssdk.services.budgets.model.ThresholdType.ABSOLUTE_VALUE
  }
}
