package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.{TargetId, PolicyId}
import scala.jdk.CollectionConverters.*
final case class ScpActionDefinition(
    policyId: PolicyId,
    targetIds: Iterable[TargetId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.ScpActionDefinition = {
    import ScpActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.ScpActionDefinition
      .builder()
      .policyId(policyId: java.lang.String)
      .targetIds(targetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.ScpActionDefinition.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.ScpActionDefinition
      .wrap(buildAwsValue())
}
object ScpActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.ScpActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.ScpActionDefinition =
      io.github.vigoo.zioaws.budgets.model
        .ScpActionDefinition(policyIdValue, targetIdsValue)
    def policyIdValue: PolicyId
    def targetIdsValue: List[TargetId]
    def policyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyIdValue)
    def targetIds: ZIO[Any, Nothing, List[TargetId]] =
      ZIO.succeed(targetIdsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.ScpActionDefinition
  ) extends io.github.vigoo.zioaws.budgets.model.ScpActionDefinition.ReadOnly {
    override def policyIdValue: PolicyId = impl.policyId(): PolicyId
    override def targetIdsValue: List[TargetId] = impl
      .targetIds()
      .asScala
      .map { item =>
        item: TargetId
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.ScpActionDefinition
  ): io.github.vigoo.zioaws.budgets.model.ScpActionDefinition.ReadOnly =
    new Wrapper(impl)
}
