package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.{
  User,
  Group,
  Role,
  PolicyArn
}
import scala.jdk.CollectionConverters.*
final case class IamActionDefinition(
    policyArn: PolicyArn,
    roles: Option[Iterable[Role]] = None,
    groups: Option[Iterable[Group]] = None,
    users: Option[Iterable[User]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.IamActionDefinition = {
    import IamActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.IamActionDefinition
      .builder()
      .policyArn(policyArn: java.lang.String)
      .optionallyWith(
        roles.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.roles)
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.users)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.IamActionDefinition.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.IamActionDefinition
      .wrap(buildAwsValue())
}
object IamActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.IamActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.IamActionDefinition =
      io.github.vigoo.zioaws.budgets.model.IamActionDefinition(
        policyArnValue,
        rolesValue.map(value => value),
        groupsValue.map(value => value),
        usersValue.map(value => value)
      )
    def policyArnValue: PolicyArn
    def rolesValue: Option[List[Role]]
    def groupsValue: Option[List[Group]]
    def usersValue: Option[List[User]]
    def policyArn: ZIO[Any, Nothing, PolicyArn] = ZIO.succeed(policyArnValue)
    def roles: ZIO[Any, AwsError, List[Role]] =
      AwsError.unwrapOptionField("roles", rolesValue)
    def groups: ZIO[Any, AwsError, List[Group]] =
      AwsError.unwrapOptionField("groups", groupsValue)
    def users: ZIO[Any, AwsError, List[User]] =
      AwsError.unwrapOptionField("users", usersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.IamActionDefinition
  ) extends io.github.vigoo.zioaws.budgets.model.IamActionDefinition.ReadOnly {
    override def policyArnValue: PolicyArn = impl.policyArn(): PolicyArn
    override def rolesValue: Option[List[Role]] = scala
      .Option(impl.roles())
      .map(value =>
        value.asScala.map { item =>
          item: Role
        }.toList
      )
    override def groupsValue: Option[List[Group]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          item: Group
        }.toList
      )
    override def usersValue: Option[List[User]] = scala
      .Option(impl.users())
      .map(value =>
        value.asScala.map { item =>
          item: User
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.IamActionDefinition
  ): io.github.vigoo.zioaws.budgets.model.IamActionDefinition.ReadOnly =
    new Wrapper(impl)
}
