package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeBudgetResponse(
    budget: Option[io.github.vigoo.zioaws.budgets.model.Budget] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse = {
    import DescribeBudgetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse
      .builder()
      .optionallyWith(budget.map(value => value.buildAwsValue()))(_.budget)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DescribeBudgetResponse.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DescribeBudgetResponse
      .wrap(buildAwsValue())
}
object DescribeBudgetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.DescribeBudgetResponse =
      io.github.vigoo.zioaws.budgets.model
        .DescribeBudgetResponse(budgetValue.map(value => value.editable))
    def budgetValue
        : Option[io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly]
    def budget: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly
    ] = AwsError.unwrapOptionField("budget", budgetValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse
  ) extends io.github.vigoo.zioaws.budgets.model.DescribeBudgetResponse.ReadOnly {
    override def budgetValue
        : Option[io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly] = scala
      .Option(impl.budget())
      .map(value => io.github.vigoo.zioaws.budgets.model.Budget.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse
  ): io.github.vigoo.zioaws.budgets.model.DescribeBudgetResponse.ReadOnly =
    new Wrapper(impl)
}
