package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.{BudgetName, AccountId}
import scala.jdk.CollectionConverters.*
final case class DescribeBudgetActionResponse(
    accountId: AccountId,
    budgetName: BudgetName,
    action: io.github.vigoo.zioaws.budgets.model.Action
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DescribeBudgetActionResponse = {
    import DescribeBudgetActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionResponse
      .builder()
      .accountId(accountId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .action(action.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionResponse.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionResponse
      .wrap(buildAwsValue())
}
object DescribeBudgetActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionResponse =
      io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionResponse(
        accountIdValue,
        budgetNameValue,
        actionValue.editable
      )
    def accountIdValue: AccountId
    def budgetNameValue: BudgetName
    def actionValue: io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
    def action: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
    ] = ZIO.succeed(actionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionResponse
  ) extends io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionResponse.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
    override def actionValue
        : io.github.vigoo.zioaws.budgets.model.Action.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Action.wrap(impl.action())
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionResponse
  ): io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionResponse.ReadOnly =
    new Wrapper(impl)
}
