package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.{BudgetName, AccountId}
import scala.jdk.CollectionConverters.*
final case class DeleteBudgetRequest(
    accountId: AccountId,
    budgetName: BudgetName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest = {
    import DeleteBudgetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DeleteBudgetRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DeleteBudgetRequest
      .wrap(buildAwsValue())
}
object DeleteBudgetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.DeleteBudgetRequest =
      io.github.vigoo.zioaws.budgets.model
        .DeleteBudgetRequest(accountIdValue, budgetNameValue)
    def accountIdValue: AccountId
    def budgetNameValue: BudgetName
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest
  ) extends io.github.vigoo.zioaws.budgets.model.DeleteBudgetRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest
  ): io.github.vigoo.zioaws.budgets.model.DeleteBudgetRequest.ReadOnly =
    new Wrapper(impl)
}
