package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.{
  GenericTimestamp,
  GenericString,
  BudgetName
}
import scala.jdk.CollectionConverters.*
final case class Budget(
    budgetName: BudgetName,
    budgetLimit: Option[io.github.vigoo.zioaws.budgets.model.Spend] = None,
    plannedBudgetLimits: Option[
      Map[GenericString, io.github.vigoo.zioaws.budgets.model.Spend]
    ] = None,
    costFilters: Option[Map[GenericString, Iterable[GenericString]]] = None,
    costTypes: Option[io.github.vigoo.zioaws.budgets.model.CostTypes] = None,
    timeUnit: io.github.vigoo.zioaws.budgets.model.TimeUnit,
    timePeriod: Option[io.github.vigoo.zioaws.budgets.model.TimePeriod] = None,
    calculatedSpend: Option[
      io.github.vigoo.zioaws.budgets.model.CalculatedSpend
    ] = None,
    budgetType: io.github.vigoo.zioaws.budgets.model.BudgetType,
    lastUpdatedTime: Option[GenericTimestamp] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.Budget = {
    import Budget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.Budget
      .builder()
      .budgetName(budgetName: java.lang.String)
      .optionallyWith(budgetLimit.map(value => value.buildAwsValue()))(
        _.budgetLimit
      )
      .optionallyWith(
        plannedBudgetLimits.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.plannedBudgetLimits)
      .optionallyWith(
        costFilters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.costFilters)
      .optionallyWith(costTypes.map(value => value.buildAwsValue()))(
        _.costTypes
      )
      .timeUnit(timeUnit.unwrap)
      .optionallyWith(timePeriod.map(value => value.buildAwsValue()))(
        _.timePeriod
      )
      .optionallyWith(calculatedSpend.map(value => value.buildAwsValue()))(
        _.calculatedSpend
      )
      .budgetType(budgetType.unwrap)
      .optionallyWith(lastUpdatedTime.map(value => value: Instant))(
        _.lastUpdatedTime
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.Budget.wrap(buildAwsValue())
}
object Budget {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.budgets.model.Budget] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.Budget =
      io.github.vigoo.zioaws.budgets.model.Budget(
        budgetNameValue,
        budgetLimitValue.map(value => value.editable),
        plannedBudgetLimitsValue.map(value =>
          value.map({ case (key, value) =>
            key -> value.editable
          })
        ),
        costFiltersValue.map(value => value),
        costTypesValue.map(value => value.editable),
        timeUnitValue,
        timePeriodValue.map(value => value.editable),
        calculatedSpendValue.map(value => value.editable),
        budgetTypeValue,
        lastUpdatedTimeValue.map(value => value)
      )
    def budgetNameValue: BudgetName
    def budgetLimitValue
        : Option[io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly]
    def plannedBudgetLimitsValue: Option[
      Map[GenericString, io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly]
    ]
    def costFiltersValue: Option[Map[GenericString, List[GenericString]]]
    def costTypesValue
        : Option[io.github.vigoo.zioaws.budgets.model.CostTypes.ReadOnly]
    def timeUnitValue: io.github.vigoo.zioaws.budgets.model.TimeUnit
    def timePeriodValue
        : Option[io.github.vigoo.zioaws.budgets.model.TimePeriod.ReadOnly]
    def calculatedSpendValue
        : Option[io.github.vigoo.zioaws.budgets.model.CalculatedSpend.ReadOnly]
    def budgetTypeValue: io.github.vigoo.zioaws.budgets.model.BudgetType
    def lastUpdatedTimeValue: Option[GenericTimestamp]
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
    def budgetLimit: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly
    ] = AwsError.unwrapOptionField("budgetLimit", budgetLimitValue)
    def plannedBudgetLimits: ZIO[Any, AwsError, Map[
      GenericString,
      io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "plannedBudgetLimits",
      plannedBudgetLimitsValue
    )
    def costFilters
        : ZIO[Any, AwsError, Map[GenericString, List[GenericString]]] =
      AwsError.unwrapOptionField("costFilters", costFiltersValue)
    def costTypes: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.CostTypes.ReadOnly
    ] = AwsError.unwrapOptionField("costTypes", costTypesValue)
    def timeUnit
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.budgets.model.TimeUnit] =
      ZIO.succeed(timeUnitValue)
    def timePeriod: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.TimePeriod.ReadOnly
    ] = AwsError.unwrapOptionField("timePeriod", timePeriodValue)
    def calculatedSpend: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.CalculatedSpend.ReadOnly
    ] = AwsError.unwrapOptionField("calculatedSpend", calculatedSpendValue)
    def budgetType
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.budgets.model.BudgetType] =
      ZIO.succeed(budgetTypeValue)
    def lastUpdatedTime: ZIO[Any, AwsError, GenericTimestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTimeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.Budget
  ) extends io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly {
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
    override def budgetLimitValue
        : Option[io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly] = scala
      .Option(impl.budgetLimit())
      .map(value => io.github.vigoo.zioaws.budgets.model.Spend.wrap(value))
    override def plannedBudgetLimitsValue: Option[
      Map[GenericString, io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly]
    ] = scala
      .Option(impl.plannedBudgetLimits())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: GenericString) -> io.github.vigoo.zioaws.budgets.model.Spend
              .wrap(value)
          })
          .toMap
      )
    override def costFiltersValue
        : Option[Map[GenericString, List[GenericString]]] = scala
      .Option(impl.costFilters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: GenericString) -> value.asScala.map { item =>
              item: GenericString
            }.toList
          })
          .toMap
      )
    override def costTypesValue
        : Option[io.github.vigoo.zioaws.budgets.model.CostTypes.ReadOnly] =
      scala
        .Option(impl.costTypes())
        .map(value =>
          io.github.vigoo.zioaws.budgets.model.CostTypes.wrap(value)
        )
    override def timeUnitValue: io.github.vigoo.zioaws.budgets.model.TimeUnit =
      io.github.vigoo.zioaws.budgets.model.TimeUnit.wrap(impl.timeUnit())
    override def timePeriodValue
        : Option[io.github.vigoo.zioaws.budgets.model.TimePeriod.ReadOnly] =
      scala
        .Option(impl.timePeriod())
        .map(value =>
          io.github.vigoo.zioaws.budgets.model.TimePeriod.wrap(value)
        )
    override def calculatedSpendValue: Option[
      io.github.vigoo.zioaws.budgets.model.CalculatedSpend.ReadOnly
    ] = scala
      .Option(impl.calculatedSpend())
      .map(value =>
        io.github.vigoo.zioaws.budgets.model.CalculatedSpend.wrap(value)
      )
    override def budgetTypeValue
        : io.github.vigoo.zioaws.budgets.model.BudgetType =
      io.github.vigoo.zioaws.budgets.model.BudgetType.wrap(impl.budgetType())
    override def lastUpdatedTimeValue: Option[GenericTimestamp] =
      scala.Option(impl.lastUpdatedTime()).map(value => value: GenericTimestamp)
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.Budget
  ): io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly = new Wrapper(impl)
}
