package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
sealed trait ActionType {
  def unwrap: software.amazon.awssdk.services.budgets.model.ActionType
}
object ActionType {
  def wrap(
      value: software.amazon.awssdk.services.budgets.model.ActionType
  ): io.github.vigoo.zioaws.budgets.model.ActionType = value match {
    case software.amazon.awssdk.services.budgets.model.ActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.budgets.model.ActionType.APPLY_IAM_POLICY =>
      val r = APPLY_IAM_POLICY
      r
    case software.amazon.awssdk.services.budgets.model.ActionType.APPLY_SCP_POLICY =>
      val r = APPLY_SCP_POLICY
      r
    case software.amazon.awssdk.services.budgets.model.ActionType.RUN_SSM_DOCUMENTS =>
      val r = RUN_SSM_DOCUMENTS
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.budgets.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ActionType =
      software.amazon.awssdk.services.budgets.model.ActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object APPLY_IAM_POLICY
      extends io.github.vigoo.zioaws.budgets.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ActionType =
      software.amazon.awssdk.services.budgets.model.ActionType.APPLY_IAM_POLICY
  }
  case object APPLY_SCP_POLICY
      extends io.github.vigoo.zioaws.budgets.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ActionType =
      software.amazon.awssdk.services.budgets.model.ActionType.APPLY_SCP_POLICY
  }
  case object RUN_SSM_DOCUMENTS
      extends io.github.vigoo.zioaws.budgets.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ActionType =
      software.amazon.awssdk.services.budgets.model.ActionType.RUN_SSM_DOCUMENTS
  }
}
