package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
sealed trait ActionStatus {
  def unwrap: software.amazon.awssdk.services.budgets.model.ActionStatus
}
object ActionStatus {
  def wrap(
      value: software.amazon.awssdk.services.budgets.model.ActionStatus
  ): io.github.vigoo.zioaws.budgets.model.ActionStatus = value match {
    case software.amazon.awssdk.services.budgets.model.ActionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.budgets.model.ActionStatus.STANDBY =>
      val r = STANDBY
      r
    case software.amazon.awssdk.services.budgets.model.ActionStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.budgets.model.ActionStatus.EXECUTION_IN_PROGRESS =>
      val r = EXECUTION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.budgets.model.ActionStatus.EXECUTION_SUCCESS =>
      val r = EXECUTION_SUCCESS
      r
    case software.amazon.awssdk.services.budgets.model.ActionStatus.EXECUTION_FAILURE =>
      val r = EXECUTION_FAILURE
      r
    case software.amazon.awssdk.services.budgets.model.ActionStatus.REVERSE_IN_PROGRESS =>
      val r = REVERSE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.budgets.model.ActionStatus.REVERSE_SUCCESS =>
      val r = REVERSE_SUCCESS
      r
    case software.amazon.awssdk.services.budgets.model.ActionStatus.REVERSE_FAILURE =>
      val r = REVERSE_FAILURE
      r
    case software.amazon.awssdk.services.budgets.model.ActionStatus.RESET_IN_PROGRESS =>
      val r = RESET_IN_PROGRESS
      r
    case software.amazon.awssdk.services.budgets.model.ActionStatus.RESET_FAILURE =>
      val r = RESET_FAILURE
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.budgets.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ActionStatus =
      software.amazon.awssdk.services.budgets.model.ActionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDBY
      extends io.github.vigoo.zioaws.budgets.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ActionStatus =
      software.amazon.awssdk.services.budgets.model.ActionStatus.STANDBY
  }
  case object PENDING
      extends io.github.vigoo.zioaws.budgets.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ActionStatus =
      software.amazon.awssdk.services.budgets.model.ActionStatus.PENDING
  }
  case object EXECUTION_IN_PROGRESS
      extends io.github.vigoo.zioaws.budgets.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ActionStatus =
      software.amazon.awssdk.services.budgets.model.ActionStatus.EXECUTION_IN_PROGRESS
  }
  case object EXECUTION_SUCCESS
      extends io.github.vigoo.zioaws.budgets.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ActionStatus =
      software.amazon.awssdk.services.budgets.model.ActionStatus.EXECUTION_SUCCESS
  }
  case object EXECUTION_FAILURE
      extends io.github.vigoo.zioaws.budgets.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ActionStatus =
      software.amazon.awssdk.services.budgets.model.ActionStatus.EXECUTION_FAILURE
  }
  case object REVERSE_IN_PROGRESS
      extends io.github.vigoo.zioaws.budgets.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ActionStatus =
      software.amazon.awssdk.services.budgets.model.ActionStatus.REVERSE_IN_PROGRESS
  }
  case object REVERSE_SUCCESS
      extends io.github.vigoo.zioaws.budgets.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ActionStatus =
      software.amazon.awssdk.services.budgets.model.ActionStatus.REVERSE_SUCCESS
  }
  case object REVERSE_FAILURE
      extends io.github.vigoo.zioaws.budgets.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ActionStatus =
      software.amazon.awssdk.services.budgets.model.ActionStatus.REVERSE_FAILURE
  }
  case object RESET_IN_PROGRESS
      extends io.github.vigoo.zioaws.budgets.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ActionStatus =
      software.amazon.awssdk.services.budgets.model.ActionStatus.RESET_IN_PROGRESS
  }
  case object RESET_FAILURE
      extends io.github.vigoo.zioaws.budgets.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ActionStatus =
      software.amazon.awssdk.services.budgets.model.ActionStatus.RESET_FAILURE
  }
}
