package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.GenericTimestamp
import scala.jdk.CollectionConverters.*
final case class ActionHistory(
    timestamp: GenericTimestamp,
    status: io.github.vigoo.zioaws.budgets.model.ActionStatus,
    eventType: io.github.vigoo.zioaws.budgets.model.EventType,
    actionHistoryDetails: io.github.vigoo.zioaws.budgets.model.ActionHistoryDetails
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.ActionHistory = {
    import ActionHistory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.ActionHistory
      .builder()
      .timestamp(timestamp: Instant)
      .status(status.unwrap)
      .eventType(eventType.unwrap)
      .actionHistoryDetails(actionHistoryDetails.buildAwsValue())
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.budgets.model.ActionHistory.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.ActionHistory.wrap(buildAwsValue())
}
object ActionHistory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.ActionHistory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.ActionHistory =
      io.github.vigoo.zioaws.budgets.model.ActionHistory(
        timestampValue,
        statusValue,
        eventTypeValue,
        actionHistoryDetailsValue.editable
      )
    def timestampValue: GenericTimestamp
    def statusValue: io.github.vigoo.zioaws.budgets.model.ActionStatus
    def eventTypeValue: io.github.vigoo.zioaws.budgets.model.EventType
    def actionHistoryDetailsValue
        : io.github.vigoo.zioaws.budgets.model.ActionHistoryDetails.ReadOnly
    def timestamp: ZIO[Any, Nothing, GenericTimestamp] =
      ZIO.succeed(timestampValue)
    def status
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.budgets.model.ActionStatus] =
      ZIO.succeed(statusValue)
    def eventType
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.budgets.model.EventType] =
      ZIO.succeed(eventTypeValue)
    def actionHistoryDetails: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.ActionHistoryDetails.ReadOnly
    ] = ZIO.succeed(actionHistoryDetailsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.ActionHistory
  ) extends io.github.vigoo.zioaws.budgets.model.ActionHistory.ReadOnly {
    override def timestampValue: GenericTimestamp =
      impl.timestamp(): GenericTimestamp
    override def statusValue
        : io.github.vigoo.zioaws.budgets.model.ActionStatus =
      io.github.vigoo.zioaws.budgets.model.ActionStatus.wrap(impl.status())
    override def eventTypeValue
        : io.github.vigoo.zioaws.budgets.model.EventType =
      io.github.vigoo.zioaws.budgets.model.EventType.wrap(impl.eventType())
    override def actionHistoryDetailsValue
        : io.github.vigoo.zioaws.budgets.model.ActionHistoryDetails.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.ActionHistoryDetails
        .wrap(impl.actionHistoryDetails())
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.ActionHistory
  ): io.github.vigoo.zioaws.budgets.model.ActionHistory.ReadOnly = new Wrapper(
    impl
  )
}
