package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class IamActionDefinition(policyArn: primitives.PolicyArn, roles: scala.Option[Iterable[primitives.Role]] = None, groups: scala.Option[Iterable[primitives.Group]] = None, users: scala.Option[Iterable[primitives.User]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.IamActionDefinition = {
    import IamActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.IamActionDefinition.builder().policyArn(policyArn: java.lang.String).optionallyWith(roles.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.roles).optionallyWith(groups.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.groups).optionallyWith(users.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.users).build()
  }
  def asReadOnly: IamActionDefinition.ReadOnly = IamActionDefinition.wrap(buildAwsValue())
}
object IamActionDefinition {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.IamActionDefinition] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: IamActionDefinition = IamActionDefinition(policyArnValue, rolesValue.map(value => value), groupsValue.map(value => value), usersValue.map(value => value))
    def policyArnValue: primitives.PolicyArn
    def rolesValue: scala.Option[List[primitives.Role]]
    def groupsValue: scala.Option[List[primitives.Group]]
    def usersValue: scala.Option[List[primitives.User]]
    def policyArn: ZIO[Any, Nothing, primitives.PolicyArn] = ZIO.succeed(policyArnValue)
    def roles: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.Role]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roles", rolesValue)
    def groups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.Group]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("groups", groupsValue)
    def users: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.User]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("users", usersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.IamActionDefinition) extends IamActionDefinition.ReadOnly {
    override def policyArnValue: primitives.PolicyArn = impl.policyArn(): primitives.PolicyArn
    override def rolesValue: scala.Option[List[primitives.Role]] = scala.Option(impl.roles()).map(value => value.asScala.map { item => 
      item: primitives.Role
    }.toList)
    override def groupsValue: scala.Option[List[primitives.Group]] = scala.Option(impl.groups()).map(value => value.asScala.map { item => 
      item: primitives.Group
    }.toList)
    override def usersValue: scala.Option[List[primitives.User]] = scala.Option(impl.users()).map(value => value.asScala.map { item => 
      item: primitives.User
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.IamActionDefinition): ReadOnly = new Wrapper(impl)
}