package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeBudgetsRequest(accountId: primitives.AccountId, maxResults: scala.Option[primitives.MaxResults] = None, nextToken: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest = {
    import DescribeBudgetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest.builder().accountId(accountId: java.lang.String).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: DescribeBudgetsRequest.ReadOnly = DescribeBudgetsRequest.wrap(buildAwsValue())
}
object DescribeBudgetsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeBudgetsRequest = DescribeBudgetsRequest(accountIdValue, maxResultsValue.map(value => value), nextTokenValue.map(value => value))
    def accountIdValue: primitives.AccountId
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def nextTokenValue: scala.Option[primitives.GenericString]
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest) extends DescribeBudgetsRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
    override def nextTokenValue: scala.Option[primitives.GenericString] = scala.Option(impl.nextToken()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest): ReadOnly = new Wrapper(impl)
}