package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeBudgetActionResponse(accountId: primitives.AccountId, budgetName: primitives.BudgetName, action: Action) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DescribeBudgetActionResponse = {
    import DescribeBudgetActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionResponse.builder().accountId(accountId: java.lang.String).budgetName(budgetName: java.lang.String).action(action.buildAwsValue()).build()
  }
  def asReadOnly: DescribeBudgetActionResponse.ReadOnly = DescribeBudgetActionResponse.wrap(buildAwsValue())
}
object DescribeBudgetActionResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DescribeBudgetActionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeBudgetActionResponse = DescribeBudgetActionResponse(accountIdValue, budgetNameValue, actionValue.editable)
    def accountIdValue: primitives.AccountId
    def budgetNameValue: primitives.BudgetName
    def actionValue: Action.ReadOnly
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
    def action: ZIO[Any, Nothing, Action.ReadOnly] = ZIO.succeed(actionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionResponse) extends DescribeBudgetActionResponse.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
    override def actionValue: Action.ReadOnly = Action.wrap(impl.action())
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionResponse): ReadOnly = new Wrapper(impl)
}