package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ActionThreshold(actionThresholdValue: primitives.NotificationThreshold, actionThresholdType: ThresholdType) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.ActionThreshold = {
    import ActionThreshold.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.ActionThreshold.builder().actionThresholdValue(actionThresholdValue: java.lang.Double).actionThresholdType(actionThresholdType.unwrap).build()
  }
  def asReadOnly: ActionThreshold.ReadOnly = ActionThreshold.wrap(buildAwsValue())
}
object ActionThreshold {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.ActionThreshold] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ActionThreshold = ActionThreshold(actionThresholdValueValue, actionThresholdTypeValue)
    def actionThresholdValueValue: primitives.NotificationThreshold
    def actionThresholdTypeValue: ThresholdType
    def actionThresholdValue: ZIO[Any, Nothing, primitives.NotificationThreshold] = ZIO.succeed(actionThresholdValueValue)
    def actionThresholdType: ZIO[Any, Nothing, ThresholdType] = ZIO.succeed(actionThresholdTypeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.ActionThreshold) extends ActionThreshold.ReadOnly {
    override def actionThresholdValueValue: primitives.NotificationThreshold = impl.actionThresholdValue(): primitives.NotificationThreshold
    override def actionThresholdTypeValue: ThresholdType = ThresholdType.wrap(impl.actionThresholdType())
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.ActionThreshold): ReadOnly = new Wrapper(impl)
}