package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ActionHistoryDetails(message: primitives.GenericString, action: Action) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.ActionHistoryDetails = {
    import ActionHistoryDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.ActionHistoryDetails.builder().message(message: java.lang.String).action(action.buildAwsValue()).build()
  }
  def asReadOnly: ActionHistoryDetails.ReadOnly = ActionHistoryDetails.wrap(buildAwsValue())
}
object ActionHistoryDetails {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.ActionHistoryDetails] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ActionHistoryDetails = ActionHistoryDetails(messageValue, actionValue.editable)
    def messageValue: primitives.GenericString
    def actionValue: Action.ReadOnly
    def message: ZIO[Any, Nothing, primitives.GenericString] = ZIO.succeed(messageValue)
    def action: ZIO[Any, Nothing, Action.ReadOnly] = ZIO.succeed(actionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.ActionHistoryDetails) extends ActionHistoryDetails.ReadOnly {
    override def messageValue: primitives.GenericString = impl.message(): primitives.GenericString
    override def actionValue: Action.ReadOnly = Action.wrap(impl.action())
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.ActionHistoryDetails): ReadOnly = new Wrapper(impl)
}