package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ActionHistory(timestamp: primitives.GenericTimestamp, status: ActionStatus, eventType: EventType, actionHistoryDetails: ActionHistoryDetails) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.ActionHistory = {
    import ActionHistory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.ActionHistory.builder().timestamp(timestamp: java.time.Instant).status(status.unwrap).eventType(eventType.unwrap).actionHistoryDetails(actionHistoryDetails.buildAwsValue()).build()
  }
  def asReadOnly: ActionHistory.ReadOnly = ActionHistory.wrap(buildAwsValue())
}
object ActionHistory {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.ActionHistory] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ActionHistory = ActionHistory(timestampValue, statusValue, eventTypeValue, actionHistoryDetailsValue.editable)
    def timestampValue: primitives.GenericTimestamp
    def statusValue: ActionStatus
    def eventTypeValue: EventType
    def actionHistoryDetailsValue: ActionHistoryDetails.ReadOnly
    def timestamp: ZIO[Any, Nothing, primitives.GenericTimestamp] = ZIO.succeed(timestampValue)
    def status: ZIO[Any, Nothing, ActionStatus] = ZIO.succeed(statusValue)
    def eventType: ZIO[Any, Nothing, EventType] = ZIO.succeed(eventTypeValue)
    def actionHistoryDetails: ZIO[Any, Nothing, ActionHistoryDetails.ReadOnly] = ZIO.succeed(actionHistoryDetailsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.ActionHistory) extends ActionHistory.ReadOnly {
    override def timestampValue: primitives.GenericTimestamp = impl.timestamp(): primitives.GenericTimestamp
    override def statusValue: ActionStatus = ActionStatus.wrap(impl.status())
    override def eventTypeValue: EventType = EventType.wrap(impl.eventType())
    override def actionHistoryDetailsValue: ActionHistoryDetails.ReadOnly = ActionHistoryDetails.wrap(impl.actionHistoryDetails())
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.ActionHistory): ReadOnly = new Wrapper(impl)
}