package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteNotificationRequest(accountId: primitives.AccountId, budgetName: primitives.BudgetName, notification: Notification) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest = {
    import DeleteNotificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest.builder().accountId(accountId: java.lang.String).budgetName(budgetName: java.lang.String).notification(notification.buildAwsValue()).build()
  }
  def asReadOnly: DeleteNotificationRequest.ReadOnly = DeleteNotificationRequest.wrap(buildAwsValue())
}
object DeleteNotificationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteNotificationRequest = DeleteNotificationRequest(accountIdValue, budgetNameValue, notificationValue.editable)
    def accountIdValue: primitives.AccountId
    def budgetNameValue: primitives.BudgetName
    def notificationValue: Notification.ReadOnly
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
    def notification: ZIO[Any, Nothing, Notification.ReadOnly] = ZIO.succeed(notificationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest) extends DeleteNotificationRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
    override def notificationValue: Notification.ReadOnly = Notification.wrap(impl.notification())
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest): ReadOnly = new Wrapper(impl)
}