/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.provider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.getlime.security.powerauth.crypto.lib.encryptor.EncryptorFactory;
import io.getlime.security.powerauth.crypto.lib.encryptor.ServerEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptedRequest;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptedResponse;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorParameters;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorScope;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorSecrets;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.v3.ServerEncryptorSecrets;
import io.getlime.security.powerauth.http.PowerAuthEncryptionHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthEncryptionHttpHeaderValidator;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.model.request.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.spring.encryption.EncryptionContext;
import io.getlime.security.powerauth.rest.api.spring.encryption.EncryptionScope;
import io.getlime.security.powerauth.rest.api.spring.encryption.PowerAuthEncryptorData;
import io.getlime.security.powerauth.rest.api.spring.encryption.PowerAuthEncryptorParameters;
import io.getlime.security.powerauth.rest.api.spring.exception.PowerAuthEncryptionException;
import io.getlime.security.powerauth.rest.api.spring.model.PowerAuthRequestBody;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PowerAuthEncryptionProviderBase {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthEncryptionProviderBase.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final EncryptorFactory encryptorFactory = new EncryptorFactory();

    @Nonnull
    public abstract PowerAuthEncryptorParameters getEciesDecryptorParameters(@Nullable String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4, String var5, Long var6) throws PowerAuthEncryptionException;

    public void decryptRequest(@Nonnull HttpServletRequest request, @Nonnull Type requestType, @Nonnull EncryptionScope encryptionScope) throws PowerAuthEncryptionException {
        if (!"POST".equals(request.getMethod())) {
            logger.warn("Invalid HTTP method: {}", (Object)request.getMethod());
            throw new PowerAuthEncryptionException();
        }
        EncryptionContext encryptionContext = this.extractEciesEncryptionContext(request, encryptionScope);
        PowerAuthEncryptorData encryptorData = new PowerAuthEncryptorData(encryptionContext);
        try {
            EciesEncryptedRequest eciesRequest;
            PowerAuthRequestBody requestBody = (PowerAuthRequestBody)request.getAttribute("X-PowerAuth-Request-Body");
            if (requestBody == null) {
                logger.warn("The X-PowerAuth-Request-Body request attribute is missing. Register the PowerAuthRequestFilter to fix this error.");
                throw new PowerAuthEncryptionException();
            }
            byte[] requestBodyBytes = requestBody.getRequestBytes();
            if (requestBodyBytes == null || requestBodyBytes.length == 0) {
                logger.warn("Invalid HTTP request");
                throw new PowerAuthEncryptionException();
            }
            try {
                eciesRequest = (EciesEncryptedRequest)this.objectMapper.readValue(requestBodyBytes, EciesEncryptedRequest.class);
            }
            catch (IOException ex) {
                logger.warn("Request deserialization failed, error: {}", (Object)ex.getMessage());
                logger.debug(ex.getMessage(), (Throwable)ex);
                throw new PowerAuthEncryptionException();
            }
            if (eciesRequest == null) {
                logger.warn("Deserialization of request body bytes resulted in null value.");
                throw new PowerAuthEncryptionException();
            }
            String version = encryptionContext.getVersion();
            String applicationKey = encryptionContext.getApplicationKey();
            String activationId = encryptionContext.getActivationId();
            EncryptedRequest encryptedRequest = new EncryptedRequest(eciesRequest.getEphemeralPublicKey(), eciesRequest.getEncryptedData(), eciesRequest.getMac(), eciesRequest.getNonce(), eciesRequest.getTimestamp());
            if (!this.encryptorFactory.getRequestResponseValidator(version).validateEncryptedRequest(encryptedRequest)) {
                logger.warn("Invalid encrypted request data");
                throw new PowerAuthEncryptionException();
            }
            if (encryptionScope == EncryptionScope.ACTIVATION_SCOPE && activationId == null) {
                logger.warn("Activation ID is required for activation scope");
                throw new PowerAuthEncryptionException();
            }
            PowerAuthEncryptorParameters encryptorParameters = this.getEciesDecryptorParameters(activationId, applicationKey, encryptedRequest.getEphemeralPublicKey(), version, encryptedRequest.getNonce(), encryptedRequest.getTimestamp());
            byte[] secretKeyBytes = Base64.getDecoder().decode(encryptorParameters.secretKey());
            byte[] sharedInfo2Base = Base64.getDecoder().decode(encryptorParameters.sharedInfo2());
            ServerEncryptor serverEncryptor = this.encryptorFactory.getServerEncryptor(encryptorData.getEncryptorId(), new EncryptorParameters(version, applicationKey, activationId), (EncryptorSecrets)new ServerEncryptorSecrets(secretKeyBytes, sharedInfo2Base));
            byte[] decryptedData = serverEncryptor.decryptRequest(encryptedRequest);
            encryptorData.setEncryptedRequest(encryptedRequest);
            encryptorData.setDecryptedRequest(decryptedData);
            encryptorData.setServerEncryptor(serverEncryptor);
            if (decryptedData.length != 0) {
                encryptorData.setRequestObject(this.deserializeRequestData(decryptedData, requestType));
            }
            request.setAttribute("X-PowerAuth-Encryption-Object", (Object)encryptorData);
        }
        catch (Exception ex) {
            logger.warn("Request decryption failed, error: " + ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthEncryptionException();
        }
    }

    @Nullable
    public EciesEncryptedResponse encryptResponse(@Nonnull Object responseObject, @Nonnull PowerAuthEncryptorData encryption) {
        try {
            EncryptionContext encryptionContext = encryption.getContext();
            ServerEncryptor serverEncryptor = encryption.getServerEncryptor();
            if (encryptionContext == null) {
                logger.warn("Encryption context is not prepared");
                throw new PowerAuthEncryptionException();
            }
            if (serverEncryptor == null || serverEncryptor.canEncryptResponse()) {
                logger.warn("Encryptor is not available or not prepared for encryption. Scope: {}", (Object)encryptionContext.getEncryptionScope());
                throw new PowerAuthEncryptionException();
            }
            byte[] responseData = this.serializeResponseData(responseObject);
            EncryptedResponse encryptedResponse = serverEncryptor.encryptResponse(responseData);
            return new EciesEncryptedResponse(encryptedResponse.getEncryptedData(), encryptedResponse.getMac(), encryptedResponse.getNonce(), encryptedResponse.getTimestamp());
        }
        catch (Exception ex) {
            logger.debug("Response encryption failed, error: " + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private Object deserializeRequestData(byte[] requestData, Type requestType) throws IOException {
        if (requestType.equals(byte[].class)) {
            return requestData;
        }
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        JavaType requestJavaType = typeFactory.constructType(requestType);
        return this.objectMapper.readValue(requestData, requestJavaType);
    }

    private byte[] serializeResponseData(Object responseObject) throws JsonProcessingException {
        if (responseObject.getClass().equals(byte[].class)) {
            return (byte[])responseObject;
        }
        return this.objectMapper.writeValueAsBytes(responseObject);
    }

    private EncryptionContext extractEciesEncryptionContext(HttpServletRequest request, EncryptionScope encryptorScope) throws PowerAuthEncryptionException {
        String encryptionHttpHeader = request.getHeader("X-PowerAuth-Encryption");
        String signatureHttpHeader = request.getHeader("X-PowerAuth-Authorization");
        if (encryptionHttpHeader == null && signatureHttpHeader == null) {
            logger.warn("Neither signature nor encryption HTTP header is present");
            throw new PowerAuthEncryptionException();
        }
        if (signatureHttpHeader != null) {
            PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(signatureHttpHeader);
            try {
                PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
            }
            catch (InvalidPowerAuthHttpHeaderException ex) {
                logger.warn("Signature HTTP header validation failed, error: {}", (Object)ex.getMessage());
                logger.debug(ex.getMessage(), (Throwable)ex);
                throw new PowerAuthEncryptionException();
            }
            String applicationKey = header.getApplicationKey();
            String activationId = header.getActivationId();
            String version = header.getVersion();
            return new EncryptionContext(applicationKey, activationId, version, (PowerAuthHttpHeader)header, encryptorScope);
        }
        PowerAuthEncryptionHttpHeader header = new PowerAuthEncryptionHttpHeader().fromValue(encryptionHttpHeader);
        try {
            PowerAuthEncryptionHttpHeaderValidator.validate((PowerAuthEncryptionHttpHeader)header, (EncryptorScope)encryptorScope.toEncryptorScope());
        }
        catch (InvalidPowerAuthHttpHeaderException ex) {
            logger.warn("Encryption validation failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthEncryptionException();
        }
        String applicationKey = header.getApplicationKey();
        String activationId = header.getActivationId();
        String version = header.getVersion();
        return new EncryptionContext(applicationKey, activationId, version, (PowerAuthHttpHeader)header, encryptorScope);
    }
}

