/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.provider;

import com.wultra.security.powerauth.client.PowerAuthClient;
import com.wultra.security.powerauth.client.model.request.GetEciesDecryptorRequest;
import com.wultra.security.powerauth.client.model.response.GetEciesDecryptorResponse;
import io.getlime.security.powerauth.rest.api.spring.encryption.PowerAuthEncryptorParameters;
import io.getlime.security.powerauth.rest.api.spring.exception.PowerAuthEncryptionException;
import io.getlime.security.powerauth.rest.api.spring.provider.PowerAuthEncryptionProviderBase;
import io.getlime.security.powerauth.rest.api.spring.service.HttpCustomizationService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PowerAuthEncryptionProvider
extends PowerAuthEncryptionProviderBase {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthEncryptionProvider.class);
    private final PowerAuthClient powerAuthClient;
    private final HttpCustomizationService httpCustomizationService;

    @Autowired
    public PowerAuthEncryptionProvider(PowerAuthClient powerAuthClient, HttpCustomizationService httpCustomizationService) {
        this.powerAuthClient = powerAuthClient;
        this.httpCustomizationService = httpCustomizationService;
    }

    @Override
    @Nonnull
    public PowerAuthEncryptorParameters getEciesDecryptorParameters(@Nullable String activationId, @Nonnull String applicationKey, @Nonnull String ephemeralPublicKey, @Nonnull String version, String nonce, Long timestamp) throws PowerAuthEncryptionException {
        try {
            GetEciesDecryptorRequest eciesDecryptorRequest = new GetEciesDecryptorRequest();
            eciesDecryptorRequest.setActivationId(activationId);
            eciesDecryptorRequest.setApplicationKey(applicationKey);
            eciesDecryptorRequest.setEphemeralPublicKey(ephemeralPublicKey);
            eciesDecryptorRequest.setProtocolVersion(version);
            eciesDecryptorRequest.setNonce(nonce);
            eciesDecryptorRequest.setTimestamp(timestamp);
            GetEciesDecryptorResponse eciesDecryptorResponse = this.powerAuthClient.getEciesDecryptor(eciesDecryptorRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
            return new PowerAuthEncryptorParameters(eciesDecryptorResponse.getSecretKey(), eciesDecryptorResponse.getSharedInfo2());
        }
        catch (Exception ex) {
            logger.warn("Get ECIES decryptor call failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthEncryptionException();
        }
    }
}

