/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.provider;

import com.wultra.core.annotations.PublicSpi;
import io.getlime.security.powerauth.rest.api.spring.model.UserInfoContext;
import io.getlime.security.powerauth.rest.api.spring.provider.UserInfoProvider;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

@PublicSpi
public class MinimalClaimsUserInfoProvider
implements UserInfoProvider {
    @Override
    public boolean shouldReturnUserInfo(@Nonnull UserInfoContext context) {
        return true;
    }

    @Override
    public Map<String, Object> fetchUserClaimsForUserId(@Nonnull UserInfoContext context) {
        return MinimalClaimsUserInfoProvider.minimalClaims(context);
    }

    private static Map<String, Object> minimalClaims(@Nonnull UserInfoContext context) {
        LinkedHashMap<String, Object> defaultClaims = new LinkedHashMap<String, Object>();
        defaultClaims.put("sub", context.getUserId());
        defaultClaims.put("jti", UUID.randomUUID().toString());
        defaultClaims.put("iat", Instant.now().getEpochSecond());
        return Collections.unmodifiableMap(defaultClaims);
    }
}

