/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.filter;

import io.getlime.security.powerauth.http.PowerAuthRequestCanonizationUtils;
import io.getlime.security.powerauth.rest.api.spring.filter.ResettableStreamHttpServletRequest;
import io.getlime.security.powerauth.rest.api.spring.model.PowerAuthRequestBody;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public class PowerAuthRequestFilterBase {
    public static ResettableStreamHttpServletRequest filterRequest(HttpServletRequest httpRequest) throws IOException {
        ResettableStreamHttpServletRequest resettableRequest = new ResettableStreamHttpServletRequest(httpRequest);
        if (httpRequest.getHeader("X-PowerAuth-Authorization") == null && httpRequest.getHeader("X-PowerAuth-Encryption") == null) {
            resettableRequest.setAttribute("X-PowerAuth-Request-Body", new PowerAuthRequestBody());
            return resettableRequest;
        }
        if (httpRequest.getMethod().equalsIgnoreCase("GET")) {
            String queryString = httpRequest.getQueryString();
            if (queryString != null && queryString.length() > 0) {
                String signatureBaseStringData = PowerAuthRequestCanonizationUtils.canonizeGetParameters((String)(queryString = URLDecoder.decode(queryString, StandardCharsets.UTF_8)));
                if (signatureBaseStringData != null) {
                    resettableRequest.setAttribute("X-PowerAuth-Request-Body", new PowerAuthRequestBody(signatureBaseStringData.getBytes(StandardCharsets.UTF_8)));
                } else {
                    resettableRequest.setAttribute("X-PowerAuth-Request-Body", new PowerAuthRequestBody());
                }
            } else {
                resettableRequest.setAttribute("X-PowerAuth-Request-Body", new PowerAuthRequestBody());
            }
        } else {
            byte[] body = resettableRequest.getRequestBody();
            if (body != null) {
                resettableRequest.setAttribute("X-PowerAuth-Request-Body", new PowerAuthRequestBody(body));
            } else {
                resettableRequest.setAttribute("X-PowerAuth-Request-Body", new PowerAuthRequestBody());
            }
        }
        return resettableRequest;
    }
}

