/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.encryption;

import io.getlime.security.powerauth.crypto.lib.encryptor.ServerEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptedRequest;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorId;
import io.getlime.security.powerauth.rest.api.spring.encryption.EncryptionContext;

public class PowerAuthEncryptorData {
    private final EncryptionContext context;
    private ServerEncryptor serverEncryptor;
    private EncryptedRequest encryptedRequest;
    private byte[] decryptedRequest;
    private Object requestObject;

    public PowerAuthEncryptorData(EncryptionContext context) {
        this.context = context;
    }

    public EncryptorId getEncryptorId() {
        switch (this.context.getEncryptionScope()) {
            case ACTIVATION_SCOPE: {
                return EncryptorId.ACTIVATION_SCOPE_GENERIC;
            }
            case APPLICATION_SCOPE: {
                return EncryptorId.APPLICATION_SCOPE_GENERIC;
            }
        }
        throw new IllegalStateException("Unsupported scope " + this);
    }

    public EncryptionContext getContext() {
        return this.context;
    }

    public ServerEncryptor getServerEncryptor() {
        return this.serverEncryptor;
    }

    public EncryptedRequest getEncryptedRequest() {
        return this.encryptedRequest;
    }

    public byte[] getDecryptedRequest() {
        return this.decryptedRequest;
    }

    public Object getRequestObject() {
        return this.requestObject;
    }

    public void setServerEncryptor(ServerEncryptor serverEncryptor) {
        this.serverEncryptor = serverEncryptor;
    }

    public void setEncryptedRequest(EncryptedRequest encryptedRequest) {
        this.encryptedRequest = encryptedRequest;
    }

    public void setDecryptedRequest(byte[] decryptedRequest) {
        this.decryptedRequest = decryptedRequest;
    }

    public void setRequestObject(Object requestObject) {
        this.requestObject = requestObject;
    }
}

