/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.converter;

import com.wultra.security.powerauth.client.model.enumeration.SignatureType;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureTypeConverter {
    private static final Logger logger = LoggerFactory.getLogger(SignatureTypeConverter.class);

    public SignatureType convertFrom(String signatureTypeString) {
        if (signatureTypeString == null) {
            return null;
        }
        try {
            signatureTypeString = signatureTypeString.toUpperCase();
            return SignatureType.enumFromString((String)signatureTypeString);
        }
        catch (IllegalArgumentException ex) {
            logger.warn("Invalid signature type, error: {}", (Object)ex.getMessage());
            logger.debug("Error details", (Throwable)ex);
            return null;
        }
    }

    public SignatureType convertFrom(PowerAuthSignatureTypes powerAuthSignatureTypes) {
        return switch (powerAuthSignatureTypes) {
            case PowerAuthSignatureTypes.POSSESSION -> SignatureType.POSSESSION;
            case PowerAuthSignatureTypes.KNOWLEDGE -> SignatureType.KNOWLEDGE;
            case PowerAuthSignatureTypes.BIOMETRY -> SignatureType.BIOMETRY;
            case PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE -> SignatureType.POSSESSION_KNOWLEDGE;
            case PowerAuthSignatureTypes.POSSESSION_BIOMETRY -> SignatureType.POSSESSION_BIOMETRY;
            default -> null;
        };
    }
}

