/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.converter;

import com.wultra.security.powerauth.client.model.response.GetActivationStatusResponse;
import io.getlime.security.powerauth.rest.api.spring.converter.ActivationStatusConverter;
import io.getlime.security.powerauth.rest.api.spring.model.ActivationContext;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ActivationContextConverter {
    private final ActivationStatusConverter activationStatusConverter;

    public ActivationContextConverter(ActivationStatusConverter activationStatusConverter) {
        this.activationStatusConverter = activationStatusConverter;
    }

    public ActivationContext fromActivationDetailResponse(GetActivationStatusResponse source) {
        Date timestampLastChange;
        Date timestampLastUsed;
        Date timestampCreated;
        ActivationContext destination = new ActivationContext();
        destination.setActivationId(source.getActivationId());
        destination.setActivationName(source.getActivationName());
        destination.setActivationStatus(this.activationStatusConverter.convertFrom(source.getActivationStatus()));
        destination.setBlockedReason(source.getBlockedReason());
        destination.setApplicationId(source.getApplicationId());
        destination.setUserId(source.getUserId());
        destination.setVersion(source.getVersion());
        destination.setPlatform(source.getPlatform());
        destination.setDeviceInfo(source.getDeviceInfo());
        destination.setExtras(source.getExtras());
        List activationFlags = source.getActivationFlags();
        if (activationFlags != null) {
            destination.getActivationFlags().addAll(activationFlags);
        }
        if ((timestampCreated = source.getTimestampCreated()) != null) {
            destination.setTimestampCreated(timestampCreated.toInstant());
        }
        if ((timestampLastUsed = source.getTimestampLastUsed()) != null) {
            destination.setTimestampLastUsed(timestampLastUsed.toInstant());
        }
        if ((timestampLastChange = source.getTimestampLastChange()) != null) {
            destination.setTimestampLastChange(timestampLastChange.toInstant());
        }
        return destination;
    }
}

