/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.annotation.support;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.getlime.security.powerauth.rest.api.spring.annotation.EncryptedRequestBody;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuthEncryption;
import io.getlime.security.powerauth.rest.api.spring.encryption.EncryptionContext;
import io.getlime.security.powerauth.rest.api.spring.encryption.PowerAuthEncryptorData;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PowerAuthEncryptionArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthEncryptionArgumentResolver.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public boolean supportsParameter(@NonNull MethodParameter parameter) {
        return parameter.hasMethodAnnotation(PowerAuthEncryption.class) && (parameter.hasParameterAnnotation(EncryptedRequestBody.class) || EncryptionContext.class.isAssignableFrom(parameter.getParameterType()));
    }

    public Object resolveArgument(@NonNull MethodParameter parameter, ModelAndViewContainer mavContainer, @NonNull NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        EncryptionContext eciesContext;
        boolean validScope;
        PowerAuthEncryption powerAuthEncryption;
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest();
        PowerAuthEncryptorData eciesObject = (PowerAuthEncryptorData)request.getAttribute("X-PowerAuth-Encryption-Object");
        if (parameter.hasParameterAnnotation(EncryptedRequestBody.class) && eciesObject != null && eciesObject.getDecryptedRequest() != null) {
            Type requestType = parameter.getGenericParameterType();
            if (requestType.equals(byte[].class)) {
                return eciesObject.getDecryptedRequest();
            }
            try {
                TypeFactory typeFactory = this.objectMapper.getTypeFactory();
                JavaType requestJavaType = typeFactory.constructType(requestType);
                return this.objectMapper.readValue(eciesObject.getDecryptedRequest(), requestJavaType);
            }
            catch (IOException ex) {
                logger.warn("Invalid request, error: {}", (Object)ex.getMessage());
                logger.debug("Error details", (Throwable)ex);
                return null;
            }
        }
        if (eciesObject != null && EncryptionContext.class.isAssignableFrom(parameter.getParameterType()) && (powerAuthEncryption = (PowerAuthEncryption)parameter.getMethodAnnotation(PowerAuthEncryption.class)) != null && (validScope = this.validateEciesScope(eciesContext = eciesObject.getContext()))) {
            return eciesContext;
        }
        return null;
    }

    private boolean validateEciesScope(EncryptionContext eciesContext) {
        switch (eciesContext.getEncryptionScope()) {
            case ACTIVATION_SCOPE: {
                if (eciesContext.getApplicationKey() == null || eciesContext.getApplicationKey().isEmpty()) {
                    logger.warn("ECIES activation scope is invalid because of missing application key");
                    return false;
                }
                if (eciesContext.getActivationId() != null && !eciesContext.getActivationId().isEmpty()) break;
                logger.warn("ECIES activation scope is invalid because of missing activation ID");
                return false;
            }
            case APPLICATION_SCOPE: {
                if (eciesContext.getApplicationKey() != null && !eciesContext.getApplicationKey().isEmpty()) break;
                logger.warn("ECIES application scope is invalid because of missing application key");
                return false;
            }
            default: {
                logger.warn("Unsupported ECIES scope: {}", (Object)eciesContext.getEncryptionScope());
                return false;
            }
        }
        return true;
    }
}

