/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.provider;

import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.spring.encryption.PowerAuthEciesEncryption;
import io.getlime.security.powerauth.rest.api.spring.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.spring.exception.authentication.PowerAuthRequestFilterException;
import io.getlime.security.powerauth.rest.api.spring.model.PowerAuthRequestBody;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PowerAuthAuthenticationProviderBase {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthAuthenticationProviderBase.class);

    @Nullable
    public abstract PowerAuthApiAuthentication validateRequestSignature(@Nonnull String var1, @Nullable byte[] var2, @Nonnull String var3, @Nonnull String var4, @Nonnull List<PowerAuthSignatureTypes> var5, @Nullable Integer var6) throws PowerAuthAuthenticationException;

    @Nonnull
    public abstract PowerAuthApiAuthentication validateRequestSignatureWithActivationDetails(@Nonnull String var1, @Nullable byte[] var2, @Nonnull String var3, @Nonnull String var4, @Nonnull List<PowerAuthSignatureTypes> var5, @Nullable Integer var6) throws PowerAuthAuthenticationException;

    @Nullable
    public abstract PowerAuthApiAuthentication validateToken(@Nonnull String var1, @Nonnull List<PowerAuthSignatureTypes> var2) throws PowerAuthAuthenticationException;

    @Nonnull
    public abstract PowerAuthApiAuthentication validateTokenWithActivationDetails(@Nonnull String var1, @Nonnull List<PowerAuthSignatureTypes> var2) throws PowerAuthAuthenticationException;

    @Nullable
    public PowerAuthApiAuthentication validateRequestSignature(@Nonnull String httpMethod, @Nullable byte[] httpBody, @Nonnull String requestUriIdentifier, @Nonnull String httpAuthorizationHeader) throws PowerAuthAuthenticationException {
        ArrayList<PowerAuthSignatureTypes> defaultAllowedSignatureTypes = new ArrayList<PowerAuthSignatureTypes>();
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_BIOMETRY);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY);
        return this.validateRequestSignature(httpMethod, httpBody, requestUriIdentifier, httpAuthorizationHeader, defaultAllowedSignatureTypes, null);
    }

    @Nullable
    public PowerAuthApiAuthentication validateRequestSignature(@Nonnull HttpServletRequest servletRequest, @Nonnull String requestUriIdentifier, @Nonnull String httpAuthorizationHeader, @Nonnull List<PowerAuthSignatureTypes> allowedSignatureTypes) throws PowerAuthAuthenticationException {
        String requestMethod = servletRequest.getMethod().toUpperCase();
        byte[] requestBodyBytes = this.extractRequestBodyBytes(servletRequest);
        return this.validateRequestSignature(requestMethod, requestBodyBytes, requestUriIdentifier, httpAuthorizationHeader, allowedSignatureTypes, null);
    }

    @Nonnull
    public PowerAuthApiAuthentication validateRequestSignatureWithActivationDetails(@Nonnull HttpServletRequest servletRequest, @Nonnull String requestUriIdentifier, @Nonnull String httpAuthorizationHeader, @Nonnull List<PowerAuthSignatureTypes> allowedSignatureTypes) throws PowerAuthAuthenticationException {
        String requestMethod = servletRequest.getMethod().toUpperCase();
        byte[] requestBodyBytes = this.extractRequestBodyBytes(servletRequest);
        return this.validateRequestSignatureWithActivationDetails(requestMethod, requestBodyBytes, requestUriIdentifier, httpAuthorizationHeader, allowedSignatureTypes, null);
    }

    @Nullable
    public PowerAuthApiAuthentication validateRequestSignature(@Nonnull HttpServletRequest servletRequest, @Nonnull String requestUriIdentifier, @Nonnull String httpAuthorizationHeader, @Nonnull List<PowerAuthSignatureTypes> allowedSignatureTypes, @Nullable Integer forcedSignatureVersion) throws PowerAuthAuthenticationException {
        String requestMethod = servletRequest.getMethod().toUpperCase();
        byte[] requestBodyBytes = this.extractRequestBodyBytes(servletRequest);
        return this.validateRequestSignature(requestMethod, requestBodyBytes, requestUriIdentifier, httpAuthorizationHeader, allowedSignatureTypes, forcedSignatureVersion);
    }

    @Nullable
    public PowerAuthApiAuthentication validateRequestSignature(@Nonnull HttpServletRequest servletRequest, @Nonnull String requestUriIdentifier, @Nonnull String httpAuthorizationHeader) throws PowerAuthAuthenticationException {
        ArrayList<PowerAuthSignatureTypes> defaultAllowedSignatureTypes = new ArrayList<PowerAuthSignatureTypes>();
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_BIOMETRY);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY);
        return this.validateRequestSignature(servletRequest, requestUriIdentifier, httpAuthorizationHeader, defaultAllowedSignatureTypes, null);
    }

    @Nullable
    public PowerAuthApiAuthentication validateToken(@Nonnull String tokenHeader) throws PowerAuthAuthenticationException {
        ArrayList<PowerAuthSignatureTypes> defaultAllowedSignatureTypes = new ArrayList<PowerAuthSignatureTypes>();
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_BIOMETRY);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY);
        return this.validateToken(tokenHeader, defaultAllowedSignatureTypes);
    }

    @Nullable
    public byte[] extractRequestBodyBytes(@Nonnull HttpServletRequest servletRequest) throws PowerAuthAuthenticationException {
        if (servletRequest.getAttribute("X-PowerAuth-Encryption-Object") != null) {
            PowerAuthEciesEncryption eciesEncryption = (PowerAuthEciesEncryption)servletRequest.getAttribute("X-PowerAuth-Encryption-Object");
            return eciesEncryption.getDecryptedRequest();
        }
        PowerAuthRequestBody requestBody = (PowerAuthRequestBody)servletRequest.getAttribute("X-PowerAuth-Request-Body");
        if (requestBody == null) {
            logger.warn("The X-PowerAuth-Request-Body request attribute is missing. Register the PowerAuthRequestFilter to fix this error.");
            throw new PowerAuthRequestFilterException();
        }
        return requestBody.getRequestBytes();
    }
}

