/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.service.v3;

import io.getlime.core.rest.model.base.response.Response;
import io.getlime.powerauth.soap.v3.PowerAuthPortV3ServiceStub;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.http.PowerAuthEncryptionHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthUpgradeException;
import io.getlime.security.powerauth.rest.api.jaxrs.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.soap.axis.client.PowerAuthServiceClient;
import java.util.Collections;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class UpgradeService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeService.class);
    @Inject
    private PowerAuthServiceClient powerAuthClient;
    @Inject
    private PowerAuthAuthenticationProvider authenticationProvider;

    public EciesEncryptedResponse upgradeStart(EciesEncryptedRequest request, PowerAuthEncryptionHttpHeader header) throws PowerAuthUpgradeException {
        try {
            String ephemeralPublicKey = request.getEphemeralPublicKey();
            String encryptedData = request.getEncryptedData();
            String mac = request.getMac();
            String activationId = header.getActivationId();
            String applicationKey = header.getApplicationKey();
            PowerAuthPortV3ServiceStub.StartUpgradeResponse upgradeResponse = this.powerAuthClient.startUpgrade(activationId, applicationKey, ephemeralPublicKey, encryptedData, mac);
            EciesEncryptedResponse response = new EciesEncryptedResponse();
            response.setMac(upgradeResponse.getMac());
            response.setEncryptedData(upgradeResponse.getEncryptedData());
            return response;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth upgrade start failed", (Throwable)ex);
            throw new PowerAuthUpgradeException();
        }
    }

    public Response upgradeCommit(String signatureHeader, HttpServletRequest httpServletRequest) throws PowerAuthAuthenticationException, PowerAuthUpgradeException {
        try {
            PowerAuthSignatureHttpHeader httpHeader;
            String applicationKey;
            byte[] requestBodyBytes = this.authenticationProvider.extractRequestBodyBytes(httpServletRequest);
            if (requestBodyBytes == null || requestBodyBytes.length == 0) {
                throw new PowerAuthAuthenticationException();
            }
            List<PowerAuthSignatureTypes> allowedSignatureTypes = Collections.singletonList(PowerAuthSignatureTypes.POSSESSION);
            PowerAuthApiAuthentication authentication = this.authenticationProvider.validateRequestSignature("POST", requestBodyBytes, "/pa/upgrade/commit", signatureHeader, allowedSignatureTypes, 3);
            if (authentication == null || authentication.getActivationId() == null) {
                throw new PowerAuthAuthenticationException();
            }
            String activationId = authentication.getActivationId();
            PowerAuthPortV3ServiceStub.CommitUpgradeResponse upgradeResponse = this.powerAuthClient.commitUpgrade(activationId, applicationKey = (httpHeader = (PowerAuthSignatureHttpHeader)authentication.getHttpHeader()).getApplicationKey());
            if (upgradeResponse.getCommitted()) {
                return new Response();
            }
            throw new PowerAuthUpgradeException();
        }
        catch (PowerAuthAuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth upgrade commit failed", (Throwable)ex);
            throw new PowerAuthUpgradeException();
        }
    }
}

