/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.service.v3;

import io.getlime.powerauth.soap.v3.PowerAuthPortV3ServiceStub;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.jaxrs.converter.v3.SignatureTypeConverter;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.request.v3.TokenRemoveRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.TokenRemoveResponse;
import io.getlime.security.powerauth.soap.axis.client.PowerAuthServiceClient;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless(name="TokenServiceV3")
public class TokenService {
    private static final Logger logger = LoggerFactory.getLogger(TokenService.class);
    @Inject
    private PowerAuthServiceClient powerAuthClient;

    public EciesEncryptedResponse createToken(EciesEncryptedRequest request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        try {
            PowerAuthSignatureTypes signatureFactors = authentication.getSignatureFactors();
            String ephemeralPublicKey = request.getEphemeralPublicKey();
            String encryptedData = request.getEncryptedData();
            String mac = request.getMac();
            SignatureTypeConverter converter = new SignatureTypeConverter();
            String activationId = authentication.getActivationId();
            PowerAuthSignatureHttpHeader httpHeader = (PowerAuthSignatureHttpHeader)authentication.getHttpHeader();
            String applicationKey = httpHeader.getApplicationKey();
            PowerAuthPortV3ServiceStub.CreateTokenResponse token = this.powerAuthClient.createToken(activationId, applicationKey, ephemeralPublicKey, encryptedData, mac, converter.convertFrom(signatureFactors));
            EciesEncryptedResponse response = new EciesEncryptedResponse();
            response.setMac(token.getMac());
            response.setEncryptedData(token.getEncryptedData());
            return response;
        }
        catch (Exception ex) {
            logger.warn("Creating PowerAuth token failed", (Throwable)ex);
            throw new PowerAuthAuthenticationException(ex.getMessage());
        }
    }

    public TokenRemoveResponse removeToken(TokenRemoveRequest request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        try {
            String activationId = authentication.getActivationId();
            String tokenId = request.getTokenId();
            this.powerAuthClient.removeToken(tokenId, activationId);
            TokenRemoveResponse response = new TokenRemoveResponse();
            response.setTokenId(tokenId);
            return response;
        }
        catch (Exception ex) {
            logger.warn("Removing PowerAuth token failed", (Throwable)ex);
            throw new PowerAuthAuthenticationException(ex.getMessage());
        }
    }
}

