/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.service.v3;

import com.google.common.io.BaseEncoding;
import io.getlime.powerauth.soap.v3.PowerAuthPortV3ServiceStub;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthSecureVaultException;
import io.getlime.security.powerauth.rest.api.jaxrs.converter.v3.SignatureTypeConverter;
import io.getlime.security.powerauth.rest.api.jaxrs.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.soap.axis.client.PowerAuthServiceClient;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless(name="SecureVaultServiceV3")
public class SecureVaultService {
    @Inject
    private PowerAuthServiceClient powerAuthClient;
    @Inject
    private PowerAuthAuthenticationProvider authenticationProvider;
    private static final Logger logger = LoggerFactory.getLogger(SecureVaultService.class);

    public EciesEncryptedResponse vaultUnlock(PowerAuthSignatureHttpHeader header, EciesEncryptedRequest request, HttpServletRequest httpServletRequest) throws PowerAuthSecureVaultException, PowerAuthAuthenticationException {
        try {
            SignatureTypeConverter converter = new SignatureTypeConverter();
            String activationId = header.getActivationId();
            String applicationKey = header.getApplicationKey();
            String signature = header.getSignature();
            PowerAuthPortV3ServiceStub.SignatureType signatureType = converter.convertFrom(header.getSignatureType());
            String nonce = header.getNonce();
            String ephemeralPublicKey = request.getEphemeralPublicKey();
            String encryptedData = request.getEncryptedData();
            String mac = request.getMac();
            byte[] requestBodyBytes = this.authenticationProvider.extractRequestBodyBytes(httpServletRequest);
            String data = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/vault/unlock", (byte[])BaseEncoding.base64().decode((CharSequence)nonce), (byte[])requestBodyBytes);
            PowerAuthPortV3ServiceStub.VaultUnlockResponse soapResponse = this.powerAuthClient.unlockVault(activationId, applicationKey, signature, signatureType, data, ephemeralPublicKey, encryptedData, mac);
            if (!soapResponse.getSignatureValid()) {
                throw new PowerAuthAuthenticationException();
            }
            return new EciesEncryptedResponse(soapResponse.getEncryptedData(), soapResponse.getMac());
        }
        catch (PowerAuthAuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth vault unlock failed", (Throwable)ex);
            throw new PowerAuthSecureVaultException();
        }
    }
}

