/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.service.v3;

import io.getlime.powerauth.soap.v3.PowerAuthPortV3ServiceStub;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.soap.axis.client.PowerAuthServiceClient;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class RecoveryService {
    @Inject
    private PowerAuthServiceClient powerAuthClient;
    private static final Logger logger = LoggerFactory.getLogger(RecoveryService.class);

    public EciesEncryptedResponse confirmRecoveryCode(EciesEncryptedRequest request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        try {
            String activationId = authentication.getActivationId();
            PowerAuthSignatureHttpHeader httpHeader = (PowerAuthSignatureHttpHeader)authentication.getHttpHeader();
            String applicationKey = httpHeader.getApplicationKey();
            if (activationId == null || applicationKey == null || request.getEphemeralPublicKey() == null || request.getEncryptedData() == null || request.getMac() == null) {
                logger.error("PowerAuth confirm recovery failed because of invalid request");
                throw new PowerAuthAuthenticationException();
            }
            PowerAuthPortV3ServiceStub.ConfirmRecoveryCodeResponse paResponse = this.powerAuthClient.confirmRecoveryCode(activationId, applicationKey, request.getEphemeralPublicKey(), request.getEncryptedData(), request.getMac());
            if (!paResponse.getActivationId().equals(activationId)) {
                logger.error("PowerAuth confirm recovery failed because of invalid activation ID in response");
                throw new PowerAuthAuthenticationException();
            }
            return new EciesEncryptedResponse(paResponse.getEncryptedData(), paResponse.getMac());
        }
        catch (Exception ex) {
            logger.warn("PowerAuth confirm recovery failed", (Throwable)ex);
            throw new PowerAuthAuthenticationException();
        }
    }
}

