/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.service.v3;

import io.getlime.powerauth.soap.v3.PowerAuthPortV3ServiceStub;
import io.getlime.security.powerauth.rest.api.base.application.PowerAuthApplicationConfiguration;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.encryption.PowerAuthEciesEncryption;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthActivationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthRecoveryException;
import io.getlime.security.powerauth.rest.api.base.provider.CustomActivationProvider;
import io.getlime.security.powerauth.rest.api.model.entity.ActivationType;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationLayer1Request;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationLayer1Response;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationRemoveResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationStatusResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.soap.axis.client.PowerAuthServiceClient;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axis2.AxisFault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless(name="ActivationServiceV3")
public class ActivationService {
    @Inject
    private PowerAuthServiceClient powerAuthClient;
    @Inject
    private PowerAuthApplicationConfiguration applicationConfiguration;
    @Inject
    private CustomActivationProvider activationProvider;
    private static final Logger logger = LoggerFactory.getLogger(ActivationService.class);

    public ActivationLayer1Response createActivation(ActivationLayer1Request request, PowerAuthEciesEncryption eciesEncryption) throws PowerAuthActivationException, PowerAuthRecoveryException {
        try {
            String applicationKey = eciesEncryption.getContext().getApplicationKey();
            EciesEncryptedRequest activationData = request.getActivationData();
            String ephemeralPublicKey = activationData.getEphemeralPublicKey();
            String encryptedData = activationData.getEncryptedData();
            String mac = activationData.getMac();
            Map customAttributes = request.getCustomAttributes();
            Map identity = request.getIdentityAttributes();
            switch (request.getType()) {
                case CODE: {
                    String activationCode = (String)request.getIdentityAttributes().get("code");
                    PowerAuthPortV3ServiceStub.PrepareActivationResponse response = this.powerAuthClient.prepareActivation(activationCode, applicationKey, ephemeralPublicKey, encryptedData, mac);
                    Map processedCustomAttributes = customAttributes;
                    if (this.activationProvider != null) {
                        processedCustomAttributes = this.activationProvider.processCustomActivationAttributes(customAttributes, response.getActivationId(), response.getUserId(), ActivationType.CODE);
                    }
                    EciesEncryptedResponse encryptedResponseL2 = new EciesEncryptedResponse();
                    encryptedResponseL2.setEncryptedData(response.getEncryptedData());
                    encryptedResponseL2.setMac(response.getMac());
                    ActivationLayer1Response responseL1 = new ActivationLayer1Response();
                    responseL1.setCustomAttributes(processedCustomAttributes);
                    responseL1.setActivationData(encryptedResponseL2);
                    return responseL1;
                }
                case CUSTOM: {
                    PowerAuthPortV3ServiceStub.CommitActivationResponse commitResponse;
                    if (this.activationProvider == null) {
                        throw new PowerAuthActivationException();
                    }
                    String userId = this.activationProvider.lookupUserIdForAttributes(identity);
                    if (userId == null || userId.equals("") || userId.length() > 255) {
                        throw new PowerAuthActivationException();
                    }
                    Integer maxFailed = this.activationProvider.getMaxFailedAttemptCount(identity, customAttributes, userId, ActivationType.CUSTOM);
                    Long maxFailedCount = maxFailed == null ? null : Long.valueOf(maxFailed.longValue());
                    Integer activationValidityPeriod = this.activationProvider.getValidityPeriodDuringActivation(identity, customAttributes, userId, ActivationType.CUSTOM);
                    Date activationExpireTimestamp = null;
                    if (activationValidityPeriod != null) {
                        Calendar activationExpiration = GregorianCalendar.getInstance();
                        activationExpiration.add(14, activationValidityPeriod);
                        activationExpireTimestamp = activationExpiration.getTime();
                    }
                    PowerAuthPortV3ServiceStub.CreateActivationResponse response = this.powerAuthClient.createActivation(userId, activationExpireTimestamp, maxFailedCount, applicationKey, ephemeralPublicKey, encryptedData, mac);
                    Map processedCustomAttributes = this.activationProvider.processCustomActivationAttributes(customAttributes, response.getActivationId(), userId, ActivationType.CUSTOM);
                    if (this.activationProvider.shouldAutoCommitActivation(identity, customAttributes, response.getActivationId(), userId, ActivationType.CUSTOM) && (commitResponse = this.powerAuthClient.commitActivation(response.getActivationId(), null)).getActivated()) {
                        this.activationProvider.activationWasCommitted(identity, customAttributes, response.getActivationId(), userId, ActivationType.CUSTOM);
                    }
                    EciesEncryptedResponse encryptedActivationData = new EciesEncryptedResponse(response.getEncryptedData(), response.getMac());
                    ActivationLayer1Response responseL1 = new ActivationLayer1Response();
                    responseL1.setCustomAttributes(processedCustomAttributes);
                    responseL1.setActivationData(encryptedActivationData);
                    return responseL1;
                }
                case RECOVERY: {
                    if (request.getIdentityAttributes() == null) {
                        throw new PowerAuthActivationException();
                    }
                    String recoveryCode = (String)request.getIdentityAttributes().get("recoveryCode");
                    String recoveryPuk = (String)request.getIdentityAttributes().get("puk");
                    if (recoveryCode == null || recoveryCode.isEmpty()) {
                        throw new PowerAuthActivationException();
                    }
                    if (recoveryPuk == null || recoveryPuk.isEmpty()) {
                        throw new PowerAuthActivationException();
                    }
                    Long maxFailedCount = null;
                    if (this.activationProvider != null) {
                        Integer maxFailed = this.activationProvider.getMaxFailedAttemptCount(identity, customAttributes, null, ActivationType.RECOVERY);
                        maxFailedCount = maxFailed == null ? null : Long.valueOf(maxFailed.longValue());
                    }
                    PowerAuthPortV3ServiceStub.RecoveryCodeActivationResponse response = this.powerAuthClient.createActivationUsingRecoveryCode(recoveryCode, recoveryPuk, applicationKey, maxFailedCount, ephemeralPublicKey, encryptedData, mac);
                    Map processedCustomAttributes = customAttributes;
                    if (this.activationProvider != null) {
                        processedCustomAttributes = this.activationProvider.processCustomActivationAttributes(customAttributes, response.getActivationId(), response.getUserId(), ActivationType.RECOVERY);
                    }
                    if (this.activationProvider == null || this.activationProvider.shouldAutoCommitActivation(identity, customAttributes, response.getActivationId(), response.getUserId(), ActivationType.RECOVERY)) {
                        PowerAuthPortV3ServiceStub.CommitActivationResponse commitResponse = this.powerAuthClient.commitActivation(response.getActivationId(), null);
                        if (this.activationProvider != null && commitResponse.getActivated()) {
                            this.activationProvider.activationWasCommitted(identity, customAttributes, response.getActivationId(), response.getUserId(), ActivationType.RECOVERY);
                        }
                    }
                    EciesEncryptedResponse encryptedResponseL2 = new EciesEncryptedResponse();
                    encryptedResponseL2.setEncryptedData(response.getEncryptedData());
                    encryptedResponseL2.setMac(response.getMac());
                    ActivationLayer1Response responseL1 = new ActivationLayer1Response();
                    responseL1.setCustomAttributes(processedCustomAttributes);
                    responseL1.setActivationData(encryptedResponseL2);
                    return responseL1;
                }
            }
            throw new PowerAuthAuthenticationException("Unsupported activation type: " + request.getType());
        }
        catch (AxisFault ex) {
            if (ex.getFaultDetailElement() != null) {
                this.handleInvalidRecoveryError(ex.getFaultDetailElement());
            }
            logger.warn("Creating PowerAuth activation failed", (Throwable)ex);
            throw new PowerAuthActivationException();
        }
        catch (Exception ex) {
            logger.warn("Creating PowerAuth activation failed", (Throwable)ex);
            throw new PowerAuthActivationException();
        }
    }

    public ActivationStatusResponse getActivationStatus(ActivationStatusRequest request) throws PowerAuthActivationException {
        try {
            String activationId = request.getActivationId();
            PowerAuthPortV3ServiceStub.GetActivationStatusResponse soapResponse = this.powerAuthClient.getActivationStatus(activationId);
            ActivationStatusResponse response = new ActivationStatusResponse();
            response.setActivationId(soapResponse.getActivationId());
            response.setEncryptedStatusBlob(soapResponse.getEncryptedStatusBlob());
            if (this.applicationConfiguration != null) {
                response.setCustomObject(this.applicationConfiguration.statusServiceCustomObject());
            }
            return response;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth activation status check failed", (Throwable)ex);
            throw new PowerAuthActivationException();
        }
    }

    public ActivationRemoveResponse removeActivation(PowerAuthApiAuthentication apiAuthentication) throws PowerAuthActivationException {
        try {
            PowerAuthPortV3ServiceStub.RemoveActivationResponse soapResponse = this.powerAuthClient.removeActivation(apiAuthentication.getActivationId(), null);
            ActivationRemoveResponse response = new ActivationRemoveResponse();
            response.setActivationId(soapResponse.getActivationId());
            return response;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth activation removal failed", (Throwable)ex);
            throw new PowerAuthActivationException();
        }
    }

    private void handleInvalidRecoveryError(SOAPFaultDetail faultDetail) throws PowerAuthRecoveryException {
        String errorCode = null;
        String errorMessage = null;
        Integer currentRecoveryPukIndex = null;
        Iterator iter = faultDetail.getAllDetailEntries();
        while (iter.hasNext()) {
            OMElement node = (OMElement)iter.next();
            switch (node.getLocalName()) {
                case "errorCode": {
                    errorCode = node.getText();
                    break;
                }
                case "localizedMessage": {
                    errorMessage = node.getText();
                    break;
                }
                case "currentRecoveryPukIndex": {
                    try {
                        currentRecoveryPukIndex = Integer.parseInt(node.getText());
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if ("ERR0028".equals(errorCode)) {
            throw new PowerAuthRecoveryException(errorMessage, "INVALID_RECOVERY_CODE", currentRecoveryPukIndex);
        }
    }
}

