/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.service.v2;

import com.google.common.io.BaseEncoding;
import io.getlime.powerauth.soap.v2.PowerAuthPortV2ServiceStub;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthSecureVaultException;
import io.getlime.security.powerauth.rest.api.jaxrs.converter.v2.SignatureTypeConverter;
import io.getlime.security.powerauth.rest.api.jaxrs.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.rest.api.model.request.v2.VaultUnlockRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.VaultUnlockResponse;
import io.getlime.security.powerauth.soap.axis.client.PowerAuthServiceClient;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless(name="SecureVaultServiceV2")
public class SecureVaultService {
    private static final Logger logger = LoggerFactory.getLogger(SecureVaultService.class);
    @Inject
    private PowerAuthServiceClient powerAuthClient;
    @Inject
    private PowerAuthAuthenticationProvider authenticationProvider;

    public VaultUnlockResponse vaultUnlock(String signatureHeader, VaultUnlockRequest request, HttpServletRequest httpServletRequest) throws PowerAuthSecureVaultException, PowerAuthAuthenticationException {
        try {
            byte[] requestBodyBytes;
            PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(signatureHeader);
            try {
                PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
            }
            catch (InvalidPowerAuthHttpHeaderException e) {
                throw new PowerAuthAuthenticationException(e.getMessage());
            }
            SignatureTypeConverter converter = new SignatureTypeConverter();
            String activationId = header.getActivationId();
            String applicationId = header.getApplicationKey();
            String signature = header.getSignature();
            PowerAuthPortV2ServiceStub.SignatureType signatureType = converter.convertFrom(header.getSignatureType());
            String nonce = header.getNonce();
            String reason = null;
            if ("2.0".equals(header.getVersion())) {
                requestBodyBytes = null;
            } else if ("2.1".equals(header.getVersion())) {
                if (request != null && request.getReason() != null) {
                    reason = request.getReason();
                }
                requestBodyBytes = this.authenticationProvider.extractRequestBodyBytes(httpServletRequest);
            } else {
                throw new PowerAuthSecureVaultException();
            }
            String data = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/vault/unlock", (byte[])BaseEncoding.base64().decode((CharSequence)nonce), requestBodyBytes);
            PowerAuthPortV2ServiceStub.VaultUnlockResponse soapResponse = this.powerAuthClient.v2().unlockVault(activationId, applicationId, data, signature, signatureType, reason);
            if (!soapResponse.getSignatureValid()) {
                throw new PowerAuthAuthenticationException();
            }
            VaultUnlockResponse response = new VaultUnlockResponse();
            response.setActivationId(soapResponse.getActivationId());
            response.setEncryptedVaultEncryptionKey(soapResponse.getEncryptedVaultEncryptionKey());
            return response;
        }
        catch (PowerAuthAuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth vault unlock failed", (Throwable)ex);
            throw new PowerAuthSecureVaultException();
        }
    }
}

