/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.service.v2;

import io.getlime.powerauth.soap.v2.PowerAuthPortV2ServiceStub;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthActivationException;
import io.getlime.security.powerauth.rest.api.model.request.v2.ActivationCreateRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.ActivationCreateResponse;
import io.getlime.security.powerauth.soap.axis.client.PowerAuthServiceClient;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless(name="ActivationServiceV2")
public class ActivationService {
    @Inject
    private PowerAuthServiceClient powerAuthClient;
    private static final Logger logger = LoggerFactory.getLogger(ActivationService.class);

    public ActivationCreateResponse createActivation(ActivationCreateRequest request) throws PowerAuthActivationException {
        try {
            String activationIDShort = request.getActivationIdShort();
            String activationNonce = request.getActivationNonce();
            String cDevicePublicKey = request.getEncryptedDevicePublicKey();
            String activationName = request.getActivationName();
            String extras = request.getExtras();
            String applicationKey = request.getApplicationKey();
            String applicationSignature = request.getApplicationSignature();
            String clientEphemeralKey = request.getEphemeralPublicKey();
            PowerAuthPortV2ServiceStub.PrepareActivationResponse soapResponse = this.powerAuthClient.v2().prepareActivation(activationIDShort, activationName, activationNonce, clientEphemeralKey, cDevicePublicKey, extras, applicationKey, applicationSignature);
            ActivationCreateResponse response = new ActivationCreateResponse();
            response.setActivationId(soapResponse.getActivationId());
            response.setActivationNonce(soapResponse.getActivationNonce());
            response.setEncryptedServerPublicKey(soapResponse.getEncryptedServerPublicKey());
            response.setEncryptedServerPublicKeySignature(soapResponse.getEncryptedServerPublicKeySignature());
            response.setEphemeralPublicKey(soapResponse.getEphemeralPublicKey());
            return response;
        }
        catch (Exception ex) {
            logger.warn("Creating PowerAuth activation failed", (Throwable)ex);
            throw new PowerAuthActivationException();
        }
    }
}

