/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.provider;

import com.google.common.io.BaseEncoding;
import io.getlime.powerauth.soap.v3.PowerAuthPortV3ServiceStub;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthTokenHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.http.validator.PowerAuthTokenHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthAuthentication;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthSignatureAuthentication;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthTokenAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.provider.PowerAuthAuthenticationProviderBase;
import io.getlime.security.powerauth.rest.api.jaxrs.authentication.PowerAuthApiAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.jaxrs.authentication.PowerAuthSignatureAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.jaxrs.authentication.PowerAuthTokenAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.jaxrs.converter.v3.SignatureTypeConverter;
import io.getlime.security.powerauth.soap.axis.client.PowerAuthServiceClient;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;

@Stateless
public class PowerAuthAuthenticationProvider
extends PowerAuthAuthenticationProviderBase {
    @Inject
    private PowerAuthServiceClient powerAuthClient;

    public PowerAuthApiAuthentication authenticate(PowerAuthAuthentication authentication) throws RemoteException {
        if (authentication instanceof PowerAuthSignatureAuthentication) {
            return this.validateSignatureAuthentication((PowerAuthSignatureAuthentication)authentication);
        }
        if (authentication instanceof PowerAuthTokenAuthentication) {
            return this.validateTokenAuthentication((PowerAuthTokenAuthentication)authentication);
        }
        return null;
    }

    private PowerAuthApiAuthentication validateSignatureAuthentication(PowerAuthSignatureAuthentication authentication) throws RemoteException {
        if (authentication.getSignatureType() != null) {
            PowerAuthPortV3ServiceStub.VerifySignatureResponse soapResponse;
            SignatureTypeConverter converter = new SignatureTypeConverter();
            PowerAuthPortV3ServiceStub.SignatureType signatureType = converter.convertFrom(authentication.getSignatureType());
            PowerAuthPortV3ServiceStub.VerifySignatureRequest soapRequest = new PowerAuthPortV3ServiceStub.VerifySignatureRequest();
            soapRequest.setActivationId(authentication.getActivationId());
            soapRequest.setApplicationKey(authentication.getApplicationKey());
            soapRequest.setSignature(authentication.getSignature());
            soapRequest.setSignatureType(signatureType);
            soapRequest.setData(PowerAuthHttpBody.getSignatureBaseString((String)authentication.getHttpMethod(), (String)authentication.getRequestUri(), (byte[])authentication.getNonce(), (byte[])authentication.getData()));
            if (authentication.getForcedSignatureVersion() != null) {
                soapRequest.setForcedSignatureVersion((long)authentication.getForcedSignatureVersion().intValue());
            }
            if ((soapResponse = this.powerAuthClient.verifySignature(soapRequest)).getSignatureValid()) {
                PowerAuthApiAuthenticationImpl apiAuthentication = new PowerAuthApiAuthenticationImpl();
                apiAuthentication.setActivationId(soapResponse.getActivationId());
                apiAuthentication.setUserId(soapResponse.getUserId());
                apiAuthentication.setApplicationId(soapResponse.getApplicationId());
                apiAuthentication.setSignatureFactors(PowerAuthSignatureTypes.getEnumFromString((String)soapResponse.getSignatureType().getValue()));
                apiAuthentication.setVersion(authentication.getVersion());
                apiAuthentication.setHttpHeader(authentication.getHttpHeader());
                return apiAuthentication;
            }
            return null;
        }
        return null;
    }

    private PowerAuthApiAuthentication validateTokenAuthentication(PowerAuthTokenAuthentication authentication) throws RemoteException {
        PowerAuthPortV3ServiceStub.ValidateTokenRequest soapRequest = new PowerAuthPortV3ServiceStub.ValidateTokenRequest();
        soapRequest.setTokenId(authentication.getTokenId());
        soapRequest.setTokenDigest(authentication.getTokenDigest());
        soapRequest.setNonce(authentication.getNonce());
        soapRequest.setTimestamp(Long.valueOf(authentication.getTimestamp()).longValue());
        PowerAuthPortV3ServiceStub.ValidateTokenResponse soapResponse = this.powerAuthClient.validateToken(soapRequest);
        if (soapResponse.getTokenValid()) {
            return this.copyAuthenticationAttributes(soapResponse.getActivationId(), soapResponse.getUserId(), soapResponse.getApplicationId(), PowerAuthSignatureTypes.getEnumFromString((String)soapResponse.getSignatureType().getValue()), authentication.getVersion(), authentication.getHttpHeader());
        }
        return null;
    }

    private PowerAuthApiAuthentication copyAuthenticationAttributes(String activationId, String userId, Long applicationId, PowerAuthSignatureTypes signatureType, String version, PowerAuthHttpHeader httpHeader) {
        PowerAuthApiAuthenticationImpl apiAuthentication = new PowerAuthApiAuthenticationImpl();
        apiAuthentication.setActivationId(activationId);
        apiAuthentication.setUserId(userId);
        apiAuthentication.setApplicationId(applicationId);
        apiAuthentication.setSignatureFactors(signatureType);
        apiAuthentication.setVersion(version);
        apiAuthentication.setHttpHeader(httpHeader);
        return apiAuthentication;
    }

    public PowerAuthApiAuthentication validateRequestSignature(String httpMethod, byte[] httpBody, String requestUriIdentifier, String httpAuthorizationHeader, List<PowerAuthSignatureTypes> allowedSignatureTypes, Integer forcedSignatureVersion) throws PowerAuthAuthenticationException {
        PowerAuthApiAuthentication auth;
        if (httpAuthorizationHeader == null || httpAuthorizationHeader.equals("undefined")) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_INVALID_EMPTY");
        }
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(httpAuthorizationHeader);
        try {
            PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException e) {
            throw new PowerAuthAuthenticationException(e.getMessage());
        }
        PowerAuthSignatureTypes expectedSignatureType = PowerAuthSignatureTypes.getEnumFromString((String)header.getSignatureType());
        if (!allowedSignatureTypes.contains(expectedSignatureType)) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_TYPE_INVALID");
        }
        PowerAuthSignatureAuthenticationImpl powerAuthAuthentication = new PowerAuthSignatureAuthenticationImpl();
        powerAuthAuthentication.setActivationId(header.getActivationId());
        powerAuthAuthentication.setApplicationKey(header.getApplicationKey());
        powerAuthAuthentication.setNonce(BaseEncoding.base64().decode((CharSequence)header.getNonce()));
        powerAuthAuthentication.setSignatureType(header.getSignatureType());
        powerAuthAuthentication.setSignature(header.getSignature());
        powerAuthAuthentication.setHttpMethod(httpMethod);
        powerAuthAuthentication.setRequestUri(requestUriIdentifier);
        powerAuthAuthentication.setData(httpBody);
        powerAuthAuthentication.setVersion(header.getVersion());
        powerAuthAuthentication.setHttpHeader((PowerAuthHttpHeader)header);
        powerAuthAuthentication.setForcedSignatureVersion(forcedSignatureVersion);
        try {
            auth = this.authenticate((PowerAuthAuthentication)powerAuthAuthentication);
        }
        catch (RemoteException e) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_SOAP_ERROR");
        }
        if (auth == null) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_INVALID_VALUE");
        }
        return auth;
    }

    public PowerAuthApiAuthentication validateToken(String tokenHeader, List<PowerAuthSignatureTypes> allowedSignatureTypes) throws PowerAuthAuthenticationException {
        PowerAuthApiAuthentication auth;
        if (tokenHeader == null || tokenHeader.equals("undefined")) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_TOKEN_INVALID_EMPTY");
        }
        PowerAuthTokenHttpHeader header = new PowerAuthTokenHttpHeader().fromValue(tokenHeader);
        try {
            PowerAuthTokenHttpHeaderValidator.validate((PowerAuthTokenHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException e) {
            throw new PowerAuthAuthenticationException(e.getMessage());
        }
        PowerAuthTokenAuthenticationImpl powerAuthTokenAuthentication = new PowerAuthTokenAuthenticationImpl();
        powerAuthTokenAuthentication.setTokenId(header.getTokenId());
        powerAuthTokenAuthentication.setTokenDigest(header.getTokenDigest());
        powerAuthTokenAuthentication.setNonce(header.getNonce());
        powerAuthTokenAuthentication.setTimestamp(header.getTimestamp());
        powerAuthTokenAuthentication.setVersion(header.getVersion());
        powerAuthTokenAuthentication.setHttpHeader((PowerAuthHttpHeader)header);
        try {
            auth = this.authenticate((PowerAuthAuthentication)powerAuthTokenAuthentication);
        }
        catch (RemoteException e) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_TOKEN_SOAP_ERROR");
        }
        if (auth == null) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_TOKEN_INVALID_VALUE");
        }
        PowerAuthSignatureTypes expectedSignatureType = auth.getSignatureFactors();
        if (!allowedSignatureTypes.contains(expectedSignatureType)) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_TOKEN_SIGNATURE_TYPE_INVALID");
        }
        return auth;
    }
}

