/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.converter.v3;

import io.getlime.powerauth.soap.v3.PowerAuthPortV3ServiceStub;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;

public class SignatureTypeConverter {
    public PowerAuthPortV3ServiceStub.SignatureType convertFrom(String signatureTypeString) {
        if (signatureTypeString == null) {
            return PowerAuthPortV3ServiceStub.SignatureType.POSSESSION_KNOWLEDGE_BIOMETRY;
        }
        try {
            signatureTypeString = signatureTypeString.toUpperCase();
            return PowerAuthPortV3ServiceStub.SignatureType.Factory.fromValue((String)signatureTypeString);
        }
        catch (IllegalArgumentException e) {
            return PowerAuthPortV3ServiceStub.SignatureType.POSSESSION_KNOWLEDGE_BIOMETRY;
        }
    }

    public PowerAuthPortV3ServiceStub.SignatureType convertFrom(PowerAuthSignatureTypes powerAuthSignatureTypes) {
        switch (powerAuthSignatureTypes) {
            case POSSESSION: {
                return PowerAuthPortV3ServiceStub.SignatureType.POSSESSION;
            }
            case KNOWLEDGE: {
                return PowerAuthPortV3ServiceStub.SignatureType.KNOWLEDGE;
            }
            case BIOMETRY: {
                return PowerAuthPortV3ServiceStub.SignatureType.BIOMETRY;
            }
            case POSSESSION_KNOWLEDGE: {
                return PowerAuthPortV3ServiceStub.SignatureType.POSSESSION_KNOWLEDGE;
            }
            case POSSESSION_BIOMETRY: {
                return PowerAuthPortV3ServiceStub.SignatureType.POSSESSION_BIOMETRY;
            }
        }
        return PowerAuthPortV3ServiceStub.SignatureType.POSSESSION_KNOWLEDGE_BIOMETRY;
    }
}

