/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.converter.v2;

import io.getlime.powerauth.soap.v2.PowerAuthPortV2ServiceStub;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;

public class SignatureTypeConverter {
    public PowerAuthPortV2ServiceStub.SignatureType convertFrom(String signatureTypeString) {
        if (signatureTypeString == null) {
            return PowerAuthPortV2ServiceStub.SignatureType.POSSESSION_KNOWLEDGE_BIOMETRY;
        }
        try {
            signatureTypeString = signatureTypeString.toUpperCase();
            return PowerAuthPortV2ServiceStub.SignatureType.Factory.fromValue((String)signatureTypeString);
        }
        catch (IllegalArgumentException e) {
            return PowerAuthPortV2ServiceStub.SignatureType.POSSESSION_KNOWLEDGE_BIOMETRY;
        }
    }

    public PowerAuthPortV2ServiceStub.SignatureType convertFrom(PowerAuthSignatureTypes powerAuthSignatureTypes) {
        switch (powerAuthSignatureTypes) {
            case POSSESSION: {
                return PowerAuthPortV2ServiceStub.SignatureType.POSSESSION;
            }
            case KNOWLEDGE: {
                return PowerAuthPortV2ServiceStub.SignatureType.KNOWLEDGE;
            }
            case BIOMETRY: {
                return PowerAuthPortV2ServiceStub.SignatureType.BIOMETRY;
            }
            case POSSESSION_KNOWLEDGE: {
                return PowerAuthPortV2ServiceStub.SignatureType.POSSESSION_KNOWLEDGE;
            }
            case POSSESSION_BIOMETRY: {
                return PowerAuthPortV2ServiceStub.SignatureType.POSSESSION_BIOMETRY;
            }
        }
        return PowerAuthPortV2ServiceStub.SignatureType.POSSESSION_KNOWLEDGE_BIOMETRY;
    }
}

