/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.controller.v3;

import io.getlime.core.rest.model.base.response.Response;
import io.getlime.security.powerauth.http.PowerAuthEncryptionHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthEncryptionHttpHeaderValidator;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthUpgradeException;
import io.getlime.security.powerauth.rest.api.jaxrs.service.v3.UpgradeService;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="pa/v3/upgrade")
@Produces(value={"application/json"})
public class UpgradeController {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeController.class);
    @Context
    private HttpServletRequest httpServletRequest;
    @Inject
    private UpgradeService upgradeService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="start")
    public EciesEncryptedResponse upgradeStart(EciesEncryptedRequest request, @HeaderParam(value="X-PowerAuth-Encryption") String encryptionHeader) throws PowerAuthUpgradeException {
        if (request == null) {
            logger.warn("Invalid request object in upgrade start");
            throw new PowerAuthUpgradeException();
        }
        PowerAuthEncryptionHttpHeader header = new PowerAuthEncryptionHttpHeader().fromValue(encryptionHeader);
        try {
            PowerAuthEncryptionHttpHeaderValidator.validate((PowerAuthEncryptionHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException ex) {
            throw new PowerAuthUpgradeException(ex.getMessage());
        }
        if (!"3.0".equals(header.getVersion())) {
            logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)header.getVersion());
            throw new PowerAuthUpgradeException();
        }
        return this.upgradeService.upgradeStart(request, header);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="commit")
    public Response upgradeCommit(@HeaderParam(value="X-PowerAuth-Authorization") String signatureHeader) throws PowerAuthAuthenticationException, PowerAuthUpgradeException {
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(signatureHeader);
        try {
            PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException ex) {
            throw new PowerAuthUpgradeException(ex.getMessage());
        }
        if (!"3.0".equals(header.getVersion())) {
            logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)header.getVersion());
            throw new PowerAuthAuthenticationException();
        }
        return this.upgradeService.upgradeCommit(signatureHeader, this.httpServletRequest);
    }
}

