/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.controller.v3;

import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.jaxrs.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.rest.api.jaxrs.service.v3.TokenService;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.request.v3.TokenRemoveRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.TokenRemoveResponse;
import java.util.Arrays;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="pa/v3/token")
@Produces(value={"application/json"})
public class TokenController {
    private static final Logger logger = LoggerFactory.getLogger(TokenController.class);
    @Context
    private HttpServletRequest httpServletRequest;
    @Inject
    private TokenService tokenServiceV3;
    @Inject
    private PowerAuthAuthenticationProvider authenticationProvider;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="create")
    public EciesEncryptedResponse createToken(EciesEncryptedRequest request, @HeaderParam(value="X-PowerAuth-Token") String tokenHeader, @HeaderParam(value="X-PowerAuth-Authorization") String authHeader) throws PowerAuthAuthenticationException {
        if (request == null) {
            logger.warn("Invalid request object in create token");
            throw new PowerAuthAuthenticationException();
        }
        PowerAuthApiAuthentication authentication = this.authenticationProvider.validateRequestSignature(this.httpServletRequest, "/pa/token/create", authHeader, Arrays.asList(PowerAuthSignatureTypes.POSSESSION, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE, PowerAuthSignatureTypes.POSSESSION_BIOMETRY, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY));
        if (authentication != null && authentication.getActivationId() != null) {
            if (!"3.0".equals(authentication.getVersion())) {
                logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)authentication.getVersion());
                throw new PowerAuthAuthenticationException();
            }
            return this.tokenServiceV3.createToken(request, authentication);
        }
        throw new PowerAuthAuthenticationException();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="remove")
    public ObjectResponse<TokenRemoveResponse> removeToken(ObjectRequest<TokenRemoveRequest> request, @HeaderParam(value="X-PowerAuth-Token") String tokenHeader, @HeaderParam(value="X-PowerAuth-Authorization") String authHeader) throws PowerAuthAuthenticationException {
        if (request.getRequestObject() == null) {
            logger.warn("Invalid request object in remove token");
            throw new PowerAuthAuthenticationException();
        }
        PowerAuthApiAuthentication authentication = this.authenticationProvider.validateRequestSignature(this.httpServletRequest, "/pa/token/remove", authHeader, Arrays.asList(PowerAuthSignatureTypes.POSSESSION, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE, PowerAuthSignatureTypes.POSSESSION_BIOMETRY, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY));
        if (authentication != null && authentication.getActivationId() != null) {
            if (!"3.0".equals(authentication.getVersion())) {
                logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)authentication.getVersion());
                throw new PowerAuthAuthenticationException();
            }
            return new ObjectResponse((Object)this.tokenServiceV3.removeToken((TokenRemoveRequest)request.getRequestObject(), authentication));
        }
        throw new PowerAuthAuthenticationException();
    }
}

