/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.controller.v3;

import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthSecureVaultException;
import io.getlime.security.powerauth.rest.api.jaxrs.service.v3.SecureVaultService;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="pa/v3/vault")
@Produces(value={"application/json"})
public class SecureVaultController {
    private static final Logger logger = LoggerFactory.getLogger(SecureVaultController.class);
    @Inject
    private SecureVaultService secureVaultServiceV3;
    @Context
    private HttpServletRequest httpServletRequest;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="unlock")
    public EciesEncryptedResponse unlockVault(@HeaderParam(value="X-PowerAuth-Authorization") String signatureHeader, EciesEncryptedRequest request, @Context HttpServletRequest httpServletRequest) throws PowerAuthAuthenticationException, PowerAuthSecureVaultException {
        if (request == null) {
            logger.warn("Invalid request object in vault unlock");
            throw new PowerAuthAuthenticationException();
        }
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(signatureHeader);
        try {
            PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException ex) {
            throw new PowerAuthAuthenticationException(ex.getMessage());
        }
        if (!"3.0".equals(header.getVersion())) {
            logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)header.getVersion());
            throw new PowerAuthAuthenticationException();
        }
        return this.secureVaultServiceV3.vaultUnlock(header, request, httpServletRequest);
    }
}

