/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.controller.v3;

import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.jaxrs.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.rest.api.jaxrs.service.v3.RecoveryService;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import java.util.Collections;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/pa/v3/recovery")
@Produces(value={"application/json"})
public class RecoveryController {
    private static final Logger logger = LoggerFactory.getLogger(RecoveryController.class);
    @Context
    private HttpServletRequest httpServletRequest;
    @Inject
    private PowerAuthAuthenticationProvider authenticationProvider;
    @Inject
    private RecoveryService recoveryService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="confirm")
    public EciesEncryptedResponse confirmRecoveryCode(EciesEncryptedRequest request, @HeaderParam(value="X-PowerAuth-Authorization") String authHeader) throws PowerAuthAuthenticationException {
        if (request == null) {
            logger.warn("Invalid request object in confirm recovery");
            throw new PowerAuthAuthenticationException();
        }
        PowerAuthApiAuthentication authentication = this.authenticationProvider.validateRequestSignature(this.httpServletRequest, "/pa/recovery/confirm", authHeader, Collections.singletonList(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE));
        if (authentication != null && authentication.getActivationId() != null) {
            if (!"3.0".equals(authentication.getVersion())) {
                logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)authentication.getVersion());
                throw new PowerAuthAuthenticationException();
            }
            return this.recoveryService.confirmRecoveryCode(request, authentication);
        }
        throw new PowerAuthAuthenticationException();
    }
}

