/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.controller.v3;

import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesScope;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.encryption.PowerAuthEciesEncryption;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthActivationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthEncryptionException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthRecoveryException;
import io.getlime.security.powerauth.rest.api.jaxrs.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.rest.api.jaxrs.provider.PowerAuthEncryptionProvider;
import io.getlime.security.powerauth.rest.api.jaxrs.service.v3.ActivationService;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationLayer1Request;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationLayer1Response;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationRemoveResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationStatusResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="pa/v3/activation")
@Produces(value={"application/json"})
public class ActivationController {
    private static final Logger logger = LoggerFactory.getLogger(ActivationController.class);
    @Inject
    private ActivationService activationServiceV3;
    @Inject
    private PowerAuthAuthenticationProvider authenticationProvider;
    @Inject
    private PowerAuthEncryptionProvider encryptionProvider;
    @Context
    private HttpServletRequest httpServletRequest;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="create")
    public EciesEncryptedResponse createActivation() throws PowerAuthActivationException, PowerAuthRecoveryException {
        try {
            PowerAuthEciesEncryption eciesEncryption = this.encryptionProvider.decryptRequest(this.httpServletRequest, ActivationLayer1Request.class, EciesScope.APPLICATION_SCOPE);
            ActivationLayer1Request layer1Request = (ActivationLayer1Request)eciesEncryption.getRequestObject();
            ActivationLayer1Response layer1Response = this.activationServiceV3.createActivation(layer1Request, eciesEncryption);
            return this.encryptionProvider.encryptResponse(layer1Response, eciesEncryption);
        }
        catch (PowerAuthEncryptionException ex) {
            throw new PowerAuthActivationException();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="status")
    public ObjectResponse<ActivationStatusResponse> getActivationStatus(ObjectRequest<ActivationStatusRequest> request) throws PowerAuthActivationException {
        if (request.getRequestObject() == null || ((ActivationStatusRequest)request.getRequestObject()).getActivationId() == null) {
            logger.warn("Invalid request object in activation status");
            throw new PowerAuthActivationException();
        }
        return new ObjectResponse((Object)this.activationServiceV3.getActivationStatus((ActivationStatusRequest)request.getRequestObject()));
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="remove")
    public ObjectResponse<ActivationRemoveResponse> removeActivation(@HeaderParam(value="X-PowerAuth-Authorization") String signatureHeader) throws PowerAuthAuthenticationException, PowerAuthActivationException {
        byte[] requestBodyBytes = this.authenticationProvider.extractRequestBodyBytes(this.httpServletRequest);
        PowerAuthApiAuthentication apiAuthentication = this.authenticationProvider.validateRequestSignature("POST", requestBodyBytes, "/pa/activation/remove", signatureHeader);
        if (apiAuthentication == null || apiAuthentication.getActivationId() == null) {
            throw new PowerAuthAuthenticationException("Signature validation failed");
        }
        if (!"3.0".equals(apiAuthentication.getVersion())) {
            logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)apiAuthentication.getVersion());
            throw new PowerAuthAuthenticationException();
        }
        return new ObjectResponse((Object)this.activationServiceV3.removeActivation(apiAuthentication));
    }
}

