/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.controller.v2;

import io.getlime.core.rest.model.base.response.Response;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.jaxrs.provider.PowerAuthAuthenticationProvider;
import java.util.Arrays;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="pa/signature")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SignatureController {
    private static final Logger logger = LoggerFactory.getLogger(SignatureController.class);
    @Context
    private HttpServletRequest httpServletRequest;
    @Inject
    private PowerAuthAuthenticationProvider authenticationProvider;

    @GET
    @Path(value="validate")
    public Response validateSignatureGet(@HeaderParam(value="X-PowerAuth-Authorization") String authHeader) throws PowerAuthAuthenticationException {
        return this.validateSignature(authHeader);
    }

    @POST
    @Path(value="validate")
    public Response validateSignaturePost(@HeaderParam(value="X-PowerAuth-Authorization") String authHeader) throws PowerAuthAuthenticationException {
        return this.validateSignature(authHeader);
    }

    @PUT
    @Path(value="validate")
    public Response validateSignaturePut(@HeaderParam(value="X-PowerAuth-Authorization") String authHeader) throws PowerAuthAuthenticationException {
        return this.validateSignature(authHeader);
    }

    @DELETE
    @Path(value="validate")
    public Response validateSignatureDelete(@HeaderParam(value="X-PowerAuth-Authorization") String authHeader) throws PowerAuthAuthenticationException {
        return this.validateSignature(authHeader);
    }

    private Response validateSignature(String authHeader) throws PowerAuthAuthenticationException {
        try {
            PowerAuthApiAuthentication authentication = this.authenticationProvider.validateRequestSignature(this.httpServletRequest, "/pa/signature/validate", authHeader, Arrays.asList(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE, PowerAuthSignatureTypes.POSSESSION_BIOMETRY, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY));
            if (authentication != null && authentication.getActivationId() != null) {
                if (!"2.0".equals(authentication.getVersion()) && !"2.1".equals(authentication.getVersion())) {
                    logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)authentication.getVersion());
                    throw new PowerAuthAuthenticationException();
                }
                return new Response();
            }
            throw new PowerAuthAuthenticationException("Signature validation failed");
        }
        catch (PowerAuthAuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PowerAuthAuthenticationException(ex.getMessage());
        }
    }
}

