/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.controller.v2;

import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthSecureVaultException;
import io.getlime.security.powerauth.rest.api.jaxrs.service.v2.SecureVaultService;
import io.getlime.security.powerauth.rest.api.model.request.v2.VaultUnlockRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.VaultUnlockResponse;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="pa/vault")
@Produces(value={"application/json"})
public class SecureVaultController {
    private static final Logger logger = LoggerFactory.getLogger(SecureVaultController.class);
    @Inject
    private SecureVaultService secureVaultServiceV2;
    @Inject
    private HttpServletRequest httpServletRequest;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="unlock")
    public ObjectResponse<VaultUnlockResponse> unlockVault(@HeaderParam(value="X-PowerAuth-Authorization") String signatureHeader, ObjectRequest<VaultUnlockRequest> request) throws PowerAuthAuthenticationException, PowerAuthSecureVaultException {
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(signatureHeader);
        try {
            PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException ex) {
            throw new PowerAuthAuthenticationException(ex.getMessage());
        }
        if (!"2.0".equals(header.getVersion()) && !"2.1".equals(header.getVersion())) {
            logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)header.getVersion());
            throw new PowerAuthAuthenticationException();
        }
        return new ObjectResponse((Object)this.secureVaultServiceV2.vaultUnlock(signatureHeader, (VaultUnlockRequest)request.getRequestObject(), this.httpServletRequest));
    }
}

