/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.controller.v2;

import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthActivationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.jaxrs.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.rest.api.jaxrs.service.v2.ActivationService;
import io.getlime.security.powerauth.rest.api.model.request.v2.ActivationCreateRequest;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.ActivationCreateResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationRemoveResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationStatusResponse;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="pa/activation")
@Produces(value={"application/json"})
public class ActivationController {
    private static final Logger logger = LoggerFactory.getLogger(ActivationController.class);
    @Inject
    private ActivationService activationServiceV2;
    @Inject
    private io.getlime.security.powerauth.rest.api.jaxrs.service.v3.ActivationService activationServiceV3;
    @Inject
    private PowerAuthAuthenticationProvider authenticationProvider;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="create")
    public ObjectResponse<ActivationCreateResponse> createActivation(ObjectRequest<ActivationCreateRequest> request) throws PowerAuthActivationException {
        if (request.getRequestObject() == null || ((ActivationCreateRequest)request.getRequestObject()).getActivationIdShort() == null) {
            logger.warn("Invalid request object in activation create");
            throw new PowerAuthActivationException();
        }
        return new ObjectResponse((Object)this.activationServiceV2.createActivation((ActivationCreateRequest)request.getRequestObject()));
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="status")
    public ObjectResponse<ActivationStatusResponse> getActivationStatus(ObjectRequest<ActivationStatusRequest> request) throws PowerAuthActivationException {
        if (request.getRequestObject() == null || ((ActivationStatusRequest)request.getRequestObject()).getActivationId() == null) {
            logger.warn("Invalid request object in activation status");
            throw new PowerAuthActivationException();
        }
        return new ObjectResponse((Object)this.activationServiceV3.getActivationStatus((ActivationStatusRequest)request.getRequestObject()));
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="remove")
    public ObjectResponse<ActivationRemoveResponse> removeActivation(@HeaderParam(value="X-PowerAuth-Authorization") String signatureHeader) throws PowerAuthAuthenticationException, PowerAuthActivationException {
        PowerAuthApiAuthentication apiAuthentication = this.authenticationProvider.validateRequestSignature("POST", null, "/pa/activation/remove", signatureHeader);
        if (apiAuthentication == null || apiAuthentication.getActivationId() == null) {
            throw new PowerAuthAuthenticationException("Signature validation failed");
        }
        if (!"2.0".equals(apiAuthentication.getVersion()) && !"2.1".equals(apiAuthentication.getVersion())) {
            logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)apiAuthentication.getVersion());
            throw new PowerAuthAuthenticationException();
        }
        return new ObjectResponse((Object)this.activationServiceV3.removeActivation(apiAuthentication));
    }
}

